#version 140

#ifdef GL_ES
precision mediump float;
#endif

uniform vec4 Time;
uniform vec3 cameraPos;

in vec3 v_Normal;
in vec3 v_Position;
in vec3 v_Position_ObjectSpace;

uniform vec4 Color;

out vec4 out_FragColor;

void main()
{
    float noiseVal = 1.0;

    vec3 camera_dir = normalize( cameraPos - v_Position );
    float ndotv = clamp( dot(camera_dir, v_Normal), 0.0, 1.0 );

    vec3 color = mix(vec3(1.0,1.0,0.3) * (2.0 + pow(ndotv, 2.0) * 10.0), vec3(1.0,0.24,0.05) * (1.0 + sqrt(ndotv) * 3.0), pow(noiseVal, 0.5 + pow(ndotv, 2.0) * 20.0));

    float alpha = clamp(ndotv * 2.0, 0.0, 1.0);
    alpha = pow(alpha,5.0);// + clamp(noiseVal * 2.0 - 1.0, 0.0, 1.0));

    out_FragColor = vec4(color * 1.5, -10.0);
}
