var missile_command = {};
missile_command['missile_command_preview'] = {
    show: function (missile) {
        model.preview.$div.show();
        model.preview.update();
        _.delay(function () {
            var focused = api.Holodeck.focused;
            model.preview.focus();
            missile.jump();
            if (focused)
                focused.focus();
        }, 30);
    },
    hide: function () {
        model.preview.$div.hide();
        model.preview.update();
    }
};
missile_command['missile_command_sanity_check'] = function () {
    var nuke_launcher = '/pa/units/land/nuke_launcher/nuke_launcher.json';
    var exactSelection = function (payload, id) {
        if (!payload) {
            return false;
        }
        var si = payload.spec_ids;
        if (Object.keys(si).length == 1) {
            if (si[nuke_launcher] && si[nuke_launcher].length == 1) {
                return true;
            }
        }
        return false;
    };
    var expectToSee;
    var expectWatcher;
    var expectationFailed = function () {
        if (!expectToSee)
            return;
        expectToSee.grouped(false);
        expectToSee = null;
        clearTimeout(expectWatcher);
        expectWatcher = null;
    };
    var expectationMet = function () {
        expectToSee = null;
        clearTimeout(expectWatcher);
        expectWatcher = null;
    };
    var expect = function (launcher) {
        if (exactSelection(model.selection(), launcher.id)) {
            return;
        }
        expectToSee = launcher;
        expectWatcher = setTimeout(expectationFailed, 1000);
    };
    var check = function (payload) {
        if (!expectToSee)
            return;
        if (exactSelection(payload, expectToSee.id)) {
            expectationMet();
        } else {
            expectationFailed();
        }
    };
    return {
        expect: expect,
        check: check
    };
}();
missile_command['missile_command_missile_view_model'] = function (preview, sanityCheck) {
    var nuke_launcher = '/pa/units/land/nuke_launcher/nuke_launcher.json';
    var matchingSelection = function () {
        var payload = model.selection();
        if (!payload) {
            return true;
        }
        var si = payload.spec_ids;
        if (Object.keys(si).length == 1) {
            if (si[nuke_launcher] && si[nuke_launcher].length == 1) {
                return true;
            }
        }
        return false;
    };
    return {
        clone: function (id) {
            var missile = Object.create(this);
            missile.id = id;
            missile.grouped = ko.observable(false);
            missile.ready = ko.observable(false);
            missile.selected = ko.observable(false);
            missile.target = ko.observable(null);
            missile.found = ko.computed(function () {
                return missile.grouped() || missile.target();
            });
            return missile;
        },
        newSelection: function (id) {
            var missile = this.clone(id);
            missile.selected(true);
            missile.captureGroup();
            return missile;
        },
        created: function (id, target) {
            var missile = this.clone(id);
            missile.target(target);
            return missile;
        },
        captureGroup: function () {
            if (!this.grouped()) {
                this.grouped(true);
                api.select.captureGroup(this.id);
            }
        },
        show: function () {
            var playerHasState = model.mode().match('command_') || !matchingSelection();
            if (this.target()) {
                preview.show(this);
            } else if (this.grouped() && !playerHasState) {
                preview.show(this);
            } else {
                preview.hide();
            }
        },
        hide: function () {
            preview.hide();
        },
        select: function () {
            api.select.recallGroup(this.id);
            sanityCheck.expect(this);
        },
        attack: function () {
            this.select();
            model.setCommandIndex(1);
        },
        jump: function () {
            if (this.target()) {
                engine.call('camera.lookAt', JSON.stringify(this.target()));
            } else if (this.grouped()) {
                this.select();
                api.camera.track(true);
                api.camera.setZoom('surface');
            }
        }
    };
}(missile_command['missile_command_preview'], missile_command['missile_command_sanity_check']);
missile_command['missile_command_registry'] = function (missileViewModel) {
    var registry = ko.observableArray();
    return {
        registry: registry,
        register: function (id) {
            var launcher = _.find(registry(), function (m) {
                    return m.id == id;
                });
            if (launcher) {
                launcher.captureGroup();
            } else {
                registry.push(missileViewModel.newSelection(id));
            }
        },
        notice: function (ids) {
            ids.forEach(function (id) {
                if (!_.find(registry(), function (m) {
                        return m.id == id;
                    })) {
                    registry.push(missileViewModel.clone(id));
                }
            });
        },
        created: function (id, target) {
            var launcher = _.find(registry(), function (m) {
                    return m.id == id;
                });
            target.zoom = 'surface';
            if (launcher) {
                launcher.target(target);
            } else {
                registry.push(missileViewModel.created(id, target));
            }
        },
        destroyed: function (id) {
            registry.remove(function (m) {
                return m.id == id;
            });
        },
        unready: function (ids) {
            if (!ids || ids.length < 1)
                return;
            _.forEach(registry(), function (m) {
                if (ids.indexOf(m.id) != -1) {
                    m.ready(false);
                }
            });
        },
        nextReady: function () {
            var m = _.find(registry(), function (m) {
                    return m.ready();
                });
            if (m && m.ready())
                m.attack();
            return m;
        },
        showSelected: function (ids) {
            ids = ids || [];
            _.forEach(registry(), function (m) {
                m.selected(ids.indexOf(m.id) != -1);
            });
        }
    };
}(missile_command['missile_command_missile_view_model']);
missile_command['missile_command_persist'] = function (missileViewModel) {
    var serializeLauncher = function (launcher) {
        return {
            id: launcher.id,
            grouped: launcher.grouped(),
            target: launcher.target()
        };
    };
    var deserializeLauncher = function (data) {
        var missile = missileViewModel.clone(data.id);
        missile.grouped(data.grouped);
        missile.target(data.target);
        return missile;
    };
    var enableStorage = function (lobbyId, registry) {
        var storage = ko.observable().extend({ session: 'missile_command_registered_' + lobbyId });
        if (storage()) {
            var ser = JSON.parse(storage());
            ser.forEach(function (data) {
                registry.push(deserializeLauncher(data));
            });
        }
        var storageObject = ko.computed(function () {
                return registry().map(serializeLauncher);
            });
        storageObject.subscribe(function (ser) {
            storage(JSON.stringify(ser));
        });
    };
    return { enableStorage: enableStorage };
}(missile_command['missile_command_missile_view_model']);
missile_command['text'] = {
    load: function (id) {
        throw new Error('Dynamic load not allowed: ' + id);
    }
};
missile_command['text_missile_command_missile_commandhtml'] = '<div class="missile_command" data-bind="visible: visible">\n  <div class="missile_command_control" data-bind="click: toggle">\n    <div class="control_chevron_auto"></div>\n    <h3>Missile Command</h3>\n  </div>\n  <div class="missile_command_cont" data-bind="visible: open, event: {mouseleave: hidePreview}">\n    <input type="button" class="btn_commit"  data-bind="click: nextReady" value="ATTACK"/>\n    <ul data-bind="foreach: registry">\n      <li data-bind="css: {missile_selected: selected}, event: {mouseenter: show}">\n        <span class="missile_id" data-bind="text: id">id</span>\n        <input type="checkbox" data-bind="checked: ready">\n        <a class="missile_command_attack" data-bind="click: attack, visible: grouped">\n          <img src="coui://ui/main/game/live_game/img/command_bar/icons_command_attack.png">\n        </a>\n        <i class="missile_command_jump ui-icon ui-icon-extlink" data-bind="click: jump, visible: found">show</i>\n      </li>\n    </ul>\n  </div>\n</div>\n';
missile_command['missile_command_missile_command'] = function (registry, persist, preview, sanityCheck, html) {
    
    var initiateStorage = function () {
        engine.asyncCall('ubernet.getGameWithPlayer').done(function (data) {
            data = JSON.parse(data);
            persist.enableStorage(data.LobbyID, registry.registry);
        });
    };
    var nuke_launcher = '/pa/units/land/nuke_launcher/nuke_launcher.json';
    var checkCommand = function (command, selected) {
        if (command == 'attack' && selected) {
            registry.unready(selected);
            registry.nextReady();
        }
    };
    model.selection.subscribe(function (payload) {
        sanityCheck.check(payload);
        if (!payload) {
            registry.showSelected([]);
            return;
        }
        var si = payload.spec_ids;
        if (Object.keys(si).length == 1) {
            if (si[nuke_launcher]) {
                if (si[nuke_launcher].length == 1) {
                    registry.register(si[nuke_launcher][0]);
                } else {
                    registry.notice(si[nuke_launcher]);
                }
            }
        }
        registry.showSelected(si[nuke_launcher]);
    });
    var originalUnitCommand = api.Holodeck.prototype.unitCommand;
    api.Holodeck.prototype.unitCommand = function (command, x, y, queue) {
        var selected = model.selection().spec_ids[nuke_launcher];
        return originalUnitCommand.apply(this, arguments).success(function () {
            checkCommand(command, selected);
        });
    };
    var originalTargetCommand = api.unit.targetCommand;
    api.unit.targetCommand = function (command, target, queue) {
        var selected = model.selection().spec_ids[nuke_launcher];
        return originalTargetCommand.apply(this, arguments).success(function () {
            checkCommand(command, selected);
        });
    };
    var settings = alertsManager.makeEmptyFilterSettings();
    settings.selectedTypes[alertsManager.WATCH_TYPES.CREATED] = ['Nuke'];
    settings.selectedTypes[alertsManager.WATCH_TYPES.DESTROYED] = ['Nuke'];
    alertsManager.addFilteredListener(function (payload) {
        console.log(payload);
        payload.list.forEach(function (alert) {
            if (alert.watch_type == alertsManager.WATCH_TYPES.CREATED) {
                registry.created(alert.id, {
                    location: alert.location,
                    planet_id: alert.planet_id
                });
            } else if (alert.watch_type == alertsManager.WATCH_TYPES.DESTROYED) {
                registry.destroyed(alert.id);
            }
        });
    }, settings);
    var viewModel = {
            visible: ko.computed(function () {
                return registry.registry().length > 0;
            }),
            registry: registry.registry,
            open: ko.observable(true),
            toggle: function () {
                this.open(!this.open());
            },
            hidePreview: preview.hide,
            nextReady: registry.nextReady
        };
    return {
        ready: function () {
            createFloatingFrame('missile_command_frame', 210, 40, {
                'offset': 'leftCenter',
                'left': 0
            });
            var $container = $('#missile_command_frame_content');
            $(html).appendTo($container);
            ko.applyBindings(viewModel, $container[0]);
            setTimeout(initiateStorage, 0);
        },
        viewModel: viewModel
    };
}(missile_command['missile_command_registry'], missile_command['missile_command_persist'], missile_command['missile_command_preview'], missile_command['missile_command_sanity_check'], missile_command['text_missile_command_missile_commandhtml']);
missile_command['missile_command_main'] = function (missile_command) {
    
    $(missile_command.ready);
}(missile_command['missile_command_missile_command']);
