var missile_command = {};
missile_command['missile_command_preview'] = {
    show: function (missile) {
        model.preview.$div.show();
        model.preview.update();
        _.delay(function () {
            var focused = api.Holodeck.focused;
            model.preview.focus();
            missile.jump();
            if (focused)
                focused.focus();
        }, 30);
    },
    hide: function () {
        model.preview.$div.hide();
        model.preview.update();
    }
};
missile_command['missile_command_missile_view_model'] = function (preview) {
    return {
        clone: function (id) {
            var missile = Object.create(this);
            missile.id = id;
            missile.ready = ko.observable(false);
            missile.selected = ko.observable(true);
            return missile;
        },
        show: function () {
            if (model.mode() != 'command_attack') {
                preview.show(this);
            }
        },
        hide: function () {
            preview.hide();
        },
        select: function () {
            api.select.recallGroup(this.id);
            model.setCommandIndex(1);
        },
        jump: function () {
            api.select.recallGroup(this.id);
            api.camera.track(true);
            api.camera.setZoom('surface');
        }
    };
}(missile_command['missile_command_preview']);
missile_command['missile_command_registry'] = function (missileViewModel) {
    var registry = ko.observableArray();
    return {
        registry: registry,
        register: function (id) {
            if (!_.find(registry(), function (m) {
                    return m.id == id;
                })) {
                console.log('unknown', id);
                api.select.captureGroup(id);
                registry.push(missileViewModel.clone(id));
            }
        },
        unready: function (ids) {
            if (!ids || ids.length < 1)
                return;
            _.forEach(registry(), function (m) {
                if (ids.indexOf(m.id) != -1) {
                    m.ready(false);
                }
            });
        },
        nextReady: function () {
            var m = _.find(registry(), function (m) {
                    return m.ready();
                });
            if (m && m.ready())
                m.select();
            return m;
        },
        showSelected: function (ids) {
            ids = ids || [];
            _.forEach(registry(), function (m) {
                m.selected(ids.indexOf(m.id) != -1);
            });
        }
    };
}(missile_command['missile_command_missile_view_model']);
missile_command['text'] = {
    load: function (id) {
        throw new Error('Dynamic load not allowed: ' + id);
    }
};
missile_command['text_missile_command_missile_commandhtml'] = '<div class="missile_command">\n  <div class="missile_command_control" data-bind="click: toggle">\n    <div class="control_chevron_auto"></div>\n    <h3>Missile Command</h3>\n  </div>\n  <div class="missile_command_cont" data-bind="visible: open, event: {mouseleave: hidePreview}">\n    <input type="button" class="btn_commit"  data-bind="click: nextReady" value="ATTACK"/>\n    <ul data-bind="foreach: registry">\n      <li data-bind="css: {missile_selected: selected}, event: {mouseenter: show}">\n        <span class="missile_id" data-bind="text: id">id</span>\n        <input type="checkbox" data-bind="checked: ready">\n        <a class="missile_command_attack" data-bind="click: select">\n          <img src="coui://ui/main/game/live_game/img/command_bar/icons_command_attack.png">\n        </a>\n        <i class="missile_command_jump ui-icon ui-icon-extlink" data-bind="click: jump">show</i>\n      </li>\n    </ul>\n  </div>\n</div>\n';
missile_command['missile_command_missile_command'] = function (registry, preview, html) {
    
    var nuke_launcher = '/pa/units/land/nuke_launcher/nuke_launcher.json';
    var checkCommand = function (command, selected) {
        if (command == 'attack' && selected) {
            registry.unready(selected);
            registry.nextReady();
        }
    };
    model.selection.subscribe(function (payload) {
        if (!payload) {
            registry.showSelected([]);
            return;
        }
        var si = payload.spec_ids;
        if (Object.keys(si).length == 1) {
            if (si[nuke_launcher] && si[nuke_launcher].length == 1) {
                registry.register(si[nuke_launcher][0]);
            }
        }
        registry.showSelected(si[nuke_launcher]);
    });
    var originalUnitCommand = api.Holodeck.prototype.unitCommand;
    api.Holodeck.prototype.unitCommand = function (command, x, y, queue) {
        var selected = model.selection().spec_ids[nuke_launcher];
        return originalUnitCommand.apply(this, arguments).success(function () {
            checkCommand(command, selected);
        });
    };
    var originalTargetCommand = api.unit.targetCommand;
    api.unit.targetCommand = function (command, target, queue) {
        var selected = model.selection().spec_ids[nuke_launcher];
        return originalTargetCommand.apply(this, arguments).success(function () {
            checkCommand(command, selected);
        });
    };
    var viewModel = {
            registry: registry.registry,
            open: ko.observable(true),
            toggle: function () {
                this.open(!this.open());
            },
            hidePreview: preview.hide,
            nextReady: registry.nextReady
        };
    return {
        ready: function () {
            createFloatingFrame('missile_command_frame', 210, 40, {
                'offset': 'leftCenter',
                'left': 0
            });
            var $container = $('#missile_command_frame_content');
            $(html).appendTo($container);
            ko.applyBindings(viewModel, $container[0]);
        }
    };
}(missile_command['missile_command_registry'], missile_command['missile_command_preview'], missile_command['text_missile_command_missile_commandhtml']);
missile_command['missile_command_main'] = function (missile_command) {
    
    $(missile_command.ready);
}(missile_command['missile_command_missile_command']);
