var instant_sandbox = {};
instant_sandbox['instant_sandbox_planet'] = {
    convertClientToServer: function (planet) {
        if (planet.hasOwnProperty('position_x')) {
            planet.position = [
                planet.position_x,
                planet.position_y
            ];
            delete planet.position_x;
            delete planet.position_y;
        }
        if (planet.hasOwnProperty('velocity_x')) {
            planet.velocity = [
                planet.velocity_x,
                planet.velocity_y
            ];
            delete planet.velocity_x;
            delete planet.velocity_y;
        }
        if (planet.hasOwnProperty('planet')) {
            planet.generator = planet.planet;
            delete planet.planet;
        }
    },
    convertServerToClient: function (planet) {
        if (planet.hasOwnProperty('position')) {
            planet.position_x = planet.position[0];
            planet.position_y = planet.position[1];
            delete planet.position;
        }
        if (planet.hasOwnProperty('velocity')) {
            planet.velocity_x = planet.velocity[0];
            planet.velocity_y = planet.velocity[1];
            delete planet.velocity;
        }
        if (planet.hasOwnProperty('generator')) {
            planet.planet = planet.generator;
            delete planet.generator;
        }
    }
};
instant_sandbox['instant_sandbox_system'] = function (planet) {
    
    return {
        convertClientToServer: function (system) {
            system.planets.forEach(planet.convertClientToServer);
        },
        convertServerToClient: function (system) {
            system.planets.forEach(planet.convertServerToClient);
        }
    };
}(instant_sandbox['instant_sandbox_planet']);
instant_sandbox['instant_sandbox_game'] = function () {
    
    panhandler.stub([
        'mount_mod_file_data',
        'server_mod_info_updated',
        'set_cheat_config',
        'connection_lost',
        'login_accepted',
        'login_rejected',
        'connection_disconnected',
        'connection_failed',
        'server_state',
        'control'
    ]);
    var state = '';
    var callerConfiguration = function () {
    };
    var textStatus = ko.observable('');
    var simReady = ko.observable(false);
    var clientReady = ko.observable(false);
    var modsReady = ko.observable(true);
    var cheatAllowChangeVision = ko.observable(false).extend({ session: 'cheat_allow_change_vision' });
    var cheatAllowChangeControl = ko.observable(false).extend({ session: 'cheat_allow_change_control' });
    var cheatAllowCreateUnit = ko.observable(false).extend({ session: 'cheat_allow_create_unit' });
    var cheatAllowModDataUpdates = ko.observable(false).extend({ session: 'cheat_allow_mod_data_updates' });
    var setCheatsFromCheatConfig = function (config) {
        console.log('setCheatsFromCheatConfig: ' + JSON.stringify(config));
        cheatAllowChangeVision(config.cheat_flags.allow_change_vision);
        cheatAllowChangeControl(config.cheat_flags.allow_change_control);
        cheatAllowCreateUnit(config.cheat_flags.allow_create_unit);
        cheatAllowModDataUpdates(config.cheat_flags.allow_mod_data_updates);
    };
    var reset = function () {
        removeHandlers();
        engine.call('reset_game_state');
        state = '';
        callerConfiguration = function () {
        };
        simReady(false);
        clientReady(false);
        modsReady(true);
    };
    var testLoading = function () {
        var worldView = api.getWorldView(0);
        if (worldView) {
            worldView.arePlanetsReady().then(function (ready) {
                clientReady(ready);
                if (!ready)
                    setTimeout(testLoading, 500);
            });
        } else {
            setTimeout(testLoading, 500);
        }
    };
    var publish = function (config) {
        reset();
        textStatus('publish game...');
        console.log('use region: ' + model.uberNetRegion());
        engine.asyncCall('ubernet.startGame', model.uberNetRegion(), 'Config').done(function (data) {
            textStatus('ubernet created game, gonna connect now...');
            data = JSON.parse(data);
            model.lobbyId(data.LobbyID);
            installHandlers(config);
            connectToServer(data);
        }).fail(function (data) {
            textStatus('failed to start ubernet game');
            reset();
        });
    };
    var joinGame = function (lobbyId) {
        textStatus('join ubernet game... ');
        engine.asyncCall('ubernet.joinGame', lobbyId).done(function (data) {
            data = JSON.parse(data);
            if (data.PollWaitTimeMS) {
                console.log('poll', data.PollWaitTimeMS);
                window.setTimeout(function () {
                    joinGame(lobbyId);
                }, 5000);
            } else {
                textStatus('ubernet game join successful, will connect now');
                model.lobbyId(lobbyId);
                connectToServer();
            }
        }).fail(function (data) {
            textStatus('failed to join ubernet game');
            reset();
        });
    };
    var connectToServer = function (data) {
        model.isLocalGame(false);
        model.gameTicket(data.Ticket);
        model.gameHostname(data.ServerHostname);
        model.gamePort(data.ServerPort);
        textStatus('connecting to game...');
        engine.call('join_game', String(data.ServerHostname), Number(data.ServerPort), String(model.displayName()), String(data.Ticket), String(JSON.stringify({ password: undefined })));
    };
    var configure = function (desc) {
        model.send_message('modify_settings', desc, function (success) {
            if (!success) {
                textStatus('modify_settings failed');
                reset();
            }
        });
    };
    var enableServerMods = function () {
        model.send_message('mod_data_available', {}, function (success, response) {
            if (success) {
                console.log('Server mods requested: ' + JSON.stringify(response));
                api.mods.sendModFileDataToServer(response.auth_token);
                modsReady(false);
            }
        });
    };
    var setSystem = function (system) {
        model.send_message('modify_system', system, function (success) {
            if (!success) {
                textStatus('modify_system failed');
                reset();
            }
        });
    };
    var resetArmies = function (armies) {
        model.send_message('reset_armies', armies, function (success) {
            if (!success) {
                textStatus('reset armies failed');
                reset();
            }
        });
    };
    var joinSlot = function (slot, army, playerId) {
        model.send_message('join_army', {
            army: slot,
            commander: { ObjectName: model.preferredCommander().ObjectName }
        });
        model.send_message('set_econ_factor', {
            id: playerId,
            economy_factor: army.economy_factor
        });
    };
    var addAI = function (slot, army) {
        model.send_message('add_ai', {
            army_index: slot,
            slot_index: 0,
            options: { 'ai': true }
        });
        model.send_message('set_econ_factor', {
            id: slot.toString(),
            economy_factor: army.economy_factor
        });
    };
    var startGame = function () {
        if (!simReady() || !clientReady() || !modsReady())
            return;
        textStatus('starting game');
        model.send_message('start_game', undefined, function (success, errorMessage) {
            if (!success) {
                textStatus('start_game failed: ' + errorMessage);
                model.joinGame(model.lobbyId());
            }
        });
    };
    simReady.subscribe(startGame);
    clientReady.subscribe(startGame);
    modsReady.subscribe(startGame);
    var states = {
            landing: function (msg) {
                removeHandlers();
                window.location.href = msg.url;
            },
            playing: function (msg) {
                removeHandlers();
                window.location.href = msg.url;
            },
            lobby: function (msg) {
                callerConfiguration(msg);
                testLoading();
            }
        };
    var installHandlers = function (config) {
        callerConfiguration = config;
        Object.keys(gameHandlers).forEach(function (handler) {
            panhandler.on(handler, gameHandlers[handler]);
        });
    };
    var removeHandlers = function () {
        Object.keys(gameHandlers).forEach(function (handler) {
            panhandler.off(handler, gameHandlers[handler]);
        });
    };
    var gameHandlers = {
            server_state: function (msg) {
                console.log('server_state');
                console.log(msg);
                if (msg.state != state) {
                    state = msg.state;
                    states[msg.state] && states[msg.state](msg);
                }
            },
            control: function (msg) {
                console.log('control');
                console.log(msg);
                simReady(msg.sim_ready);
            },
            mount_mod_file_data: function (payload) {
                console.log('Mounting mod file data: ' + JSON.stringify(payload));
                api.mods.mountModFileData();
            },
            server_mod_info_updated: function (payload) {
                console.log('server_mod_info_updated', payload);
                modsReady(true);
            },
            set_cheat_config: function (payload) {
                setCheatsFromCheatConfig(payload);
            },
            connection_disconnected: function (payload) {
                var message = loc('!LOC(connect_to_game:connection_to_server_lost.message):CONNECTION TO SERVER LOST');
                textStatus(message);
                console.log(payload);
                reset();
            },
            connection_failed: function (payload) {
                var message = loc('!LOC(connect_to_game:connection_to_server_failed.message):CONNECTION TO SERVER FAILED');
                textStatus(message);
                console.log(payload);
                reset();
            },
            login_accepted: function (payload) {
                var message = loc('!LOC(connect_to_game:login_accepted.message):LOGIN ACCEPTED');
                textStatus(message);
                app.hello(gameHandlers.server_state, gameHandlers.connection_disconnected);
            },
            login_rejected: function (payload) {
                var message = loc('!LOC(connect_to_game:login_to_server_rejected.message):LOGIN TO SERVER REJECTED');
                textStatus(message);
                console.log(payload);
                reset();
            }
        };
    return {
        reset: reset,
        publish: publish,
        joinGame: joinGame,
        connectToServer: connectToServer,
        configure: configure,
        enableServerMods: enableServerMods,
        setSystem: setSystem,
        resetArmies: resetArmies,
        joinSlot: joinSlot,
        addAI: addAI,
        startGame: startGame,
        simReady: simReady,
        clientReady: clientReady,
        textStatus: textStatus
    };
}();
instant_sandbox['instant_sandbox_defaults'] = function () {
    var FreeForAll = '0';
    var TeamArmies = '1';
    var Alliance = '2';
    var VersusAi = '3';
    var Code = 'code';
    var Settings = 'settings';
    return {
        config: Settings,
        settings: {
            type: FreeForAll,
            spectators: 0,
            blocked: [],
            public: false,
            friends: [],
            password: undefined
        },
        armies: [
            {
                'slots': 1,
                alliance: false,
                economy_factor: 5,
                player: true
            },
            {
                'slots': 1,
                alliance: false,
                economy_factor: 0
            }
        ],
        system: {
            'name': 'Instant Sandbox System',
            'planets': [{
                    'name': 'Small Moon',
                    'mass': 10000,
                    'position_x': 53567.4,
                    'position_y': 8786.55,
                    'velocity_x': -15.5348,
                    'velocity_y': 94.7081,
                    'required_thrust_to_move': 0,
                    'starting_planet': true,
                    'planet': {
                        'seed': 78462,
                        'radius': 400,
                        'heightRange': 75,
                        'waterHeight': 0,
                        'temperature': 0,
                        'metalDensity': 50,
                        'metalClusters': 50,
                        'biomeScale': 50,
                        'biome': 'sandbox'
                    }
                }]
        }
    };
}();
instant_sandbox['instant_sandbox_config'] = function (defaults) {
    if (defaults.config == 'code') {
        return defaults;
    }
    initialSettingValue('instant_sandbox_ai_armies', 1);
    initialSettingValue('instant_sandbox_ai_slots', 1);
    initialSettingValue('instant_sandbox_ai_economy', 0);
    initialSettingValue('instant_sandbox_player_economy', 50);
    var settings = decode(localStorage.settings);
    var config = {
            settings: defaults.settings,
            armies: [{
                    'slots': 1,
                    player: true,
                    alliance: false,
                    economy_factor: settings.instant_sandbox_player_economy / 10
                }],
            system: decode(localStorage.instant_sandbox_system) || defaults.system
        };
    for (var i = 0; i < settings.instant_sandbox_ai_armies; i++) {
        config.armies.push({
            slots: 1,
            alliance: false,
            economy_factor: settings.instant_sandbox_ai_economy / 10
        });
    }
    return config;
}(instant_sandbox['instant_sandbox_defaults']);
instant_sandbox['text'] = {
    load: function (id) {
        throw new Error('Dynamic load not allowed: ' + id);
    }
};
instant_sandbox['text_instant_sandbox_dialoghtml'] = '<div id="instant_sandbox_dialog">\n  <div class="div_alert" >\n    <img src="coui://ui/main/shared/img/loading.gif" class="img_progress_icon" style="margin:0px 8px 0px 0px"></img>\n    <div id="instant_sandbox_msg_progress" class="msg_progress_icon" data-bind="text: instantSandboxProgress"></div>\n  </div>\n</div>\n';
instant_sandbox['instant_sandbox_dialog'] = function (html) {
    
    var viewModel = { instantSandboxProgress: ko.observable('') };
    return {
        open: function (message) {
            var $dialog = $(html);
            ko.applyBindings(viewModel, $dialog[0]);
            $('body').append($dialog);
            $dialog.dialog({
                dialogClass: 'no-close',
                closeOnEscape: false,
                draggable: false,
                resizable: false,
                height: 240,
                width: 600,
                modal: true,
                buttons: {}
            });
            viewModel.instantSandboxProgress(message || 'Working...');
        },
        progress: viewModel.instantSandboxProgress
    };
}(instant_sandbox['text_instant_sandbox_dialoghtml']);
instant_sandbox['instant_sandbox_pastats'] = function () {
    if (window['paStatsGlobal'] == undefined) {
        return {
            setLobby: function (lobbyId) {
            },
            setSystem: function (system) {
            },
            setArmies: function (armies) {
            },
            setPlayer: function (index) {
            }
        };
    }
    console.log('Instant Sandbox: using PAStats setup');
    var rgb = function (triple) {
        if (triple == undefined)
            return '';
        return 'rgb(' + triple[0] + ',' + triple[1] + ',' + triple[2] + ')';
    };
    return {
        setLobby: function (lobbyId) {
            localStorage['lobbyId'] = encode(lobbyId);
            localStorage[paStatsGlobal.isRankedGameKey] = encode(false);
        },
        setSystem: function (system) {
            localStorage['pa_stats_loaded_planet_json'] = JSON.stringify(system);
        },
        setArmies: function (armies) {
            var teams = [];
            armies.forEach(function (army, index) {
                teams.push({
                    index: index,
                    players: army.ai ? [{ displayName: 'AI' }] : [],
                    primaryColor: '',
                    secondaryColor: ''
                });
            });
            localStorage[paStatsGlobal.pa_stats_session_teams] = encode(teams);
        },
        setPlayer: function (index, player) {
            localStorage[paStatsGlobal.pa_stats_session_team_index] = encode(index);
            var teams = decode(localStorage[paStatsGlobal.pa_stats_session_teams]);
            teams[index].primaryColor = rgb(player.color[0]);
            teams[index].secondaryColor = rgb(player.color[1]);
            teams[index].players = [{ displayName: player.name }], console.log(teams);
            localStorage[paStatsGlobal.pa_stats_session_teams] = encode(teams);
        }
    };
}();
instant_sandbox['text_instant_sandbox_buttonhtml'] = '<a href="#" class="nav_item" id="start_instant_sandbox" data-bind="click: startInstantSandbox, click_sound: \'default\', rollover_sound: \'default\', css: { nav_item_disabled: !allowNewOrJoinGame() } ">\n    <span class="nav_item_text" data-bind="css: { nav_item_text_disabled: !allowNewOrJoinGame() }">\n        <loc desc="">INSTANT SANDBOX</loc>\n    </span>\n</a>\n';
instant_sandbox['instant_sandbox_start'] = function (system, game, config, dialog, pastats, html) {
    
    var hasPAStats = function () {
        for (var i in scene_mod_list.start) {
            if (scene_mod_list.start[i].match('pastats/scenes/ranked_matcher')) {
                return true;
            }
        }
        return false;
    };
    var viewModel = {
            allowNewOrJoinGame: model.allowNewOrJoinGame,
            startInstantSandbox: function () {
                dialog.open('Making Sandbox');
                game.publish(gameConfiguration);
            }
        };
    model.startInstantSandbox = viewModel.startInstantSandbox;
    var gameConfiguration = function (msg) {
        dialog.progress('lobby: configure planets...');
        pastats.setLobby(model.lobbyId());
        game.configure(config.settings);
        pastats.setSystem(config.system);
        system.convertClientToServer(config.system);
        game.setSystem(config.system);
        pastats.setArmies(config.armies);
        game.resetArmies(config.armies);
        dialog.progress('lobby: configuring players...');
        config.armies.forEach(function (army, army_index) {
            if (army.player) {
                game.joinSlot(army_index, army, msg.data.players[0].id);
                pastats.setPlayer(army_index, msg.data.players[0]);
            } else {
                game.addAI(army_index, army);
            }
        });
        game.enableServerMods();
        dialog.progress('Generating Planets');
    };
    dialog.progress.subscribe(function (message) {
        console.log(message);
    });
    return {
        ready: function () {
            if (hasPAStats())
                return;
            var $button = $(html);
            $('#navigation_items').append($button);
            ko.applyBindings(viewModel, $button[0]);
            game.textStatus.subscribe(dialog.progress);
        }
    };
}(instant_sandbox['instant_sandbox_system'], instant_sandbox['instant_sandbox_game'], instant_sandbox['instant_sandbox_config'], instant_sandbox['instant_sandbox_dialog'], instant_sandbox['instant_sandbox_pastats'], instant_sandbox['text_instant_sandbox_buttonhtml']);
instant_sandbox['instant_sandbox_main'] = function (start) {
    
    start.ready();
}(instant_sandbox['instant_sandbox_start']);
