var instant_sandbox = {};
instant_sandbox['instant_sandbox_planet'] = {
    convertClientToServer: function (planet) {
        if (planet.hasOwnProperty('position_x')) {
            planet.position = [
                planet.position_x,
                planet.position_y
            ];
            delete planet.position_x;
            delete planet.position_y;
        }
        if (planet.hasOwnProperty('velocity_x')) {
            planet.velocity = [
                planet.velocity_x,
                planet.velocity_y
            ];
            delete planet.velocity_x;
            delete planet.velocity_y;
        }
        if (planet.hasOwnProperty('planet')) {
            planet.generator = planet.planet;
            delete planet.planet;
        }
    },
    convertServerToClient: function (planet) {
        if (planet.hasOwnProperty('position')) {
            planet.position_x = planet.position[0];
            planet.position_y = planet.position[1];
            delete planet.position;
        }
        if (planet.hasOwnProperty('velocity')) {
            planet.velocity_x = planet.velocity[0];
            planet.velocity_y = planet.velocity[1];
            delete planet.velocity;
        }
        if (planet.hasOwnProperty('generator')) {
            planet.planet = planet.generator;
            delete planet.generator;
        }
    }
};
instant_sandbox['instant_sandbox_system'] = function (planet) {
    
    return {
        convertClientToServer: function (system) {
            system.planets.forEach(planet.convertClientToServer);
        },
        convertServerToClient: function (system) {
            system.planets.forEach(planet.convertServerToClient);
        }
    };
}(instant_sandbox['instant_sandbox_planet']);
instant_sandbox['instant_sandbox_game'] = function () {
    
    panhandler.stub([
        'connection_lost',
        'login_accepted',
        'login_rejected',
        'connection_disconnected',
        'connection_failed',
        'server_state',
        'control'
    ]);
    var state = '';
    var callerConfiguration = function () {
    };
    var textStatus = ko.observable('');
    var reset = function () {
        removeHandlers();
        engine.call('reset_game_state');
        state = '';
        callerConfiguration = function () {
        };
    };
    var publish = function (config) {
        reset();
        textStatus('publish game...');
        console.log('use region: ' + model.uberNetRegion());
        engine.asyncCall('ubernet.startGame', model.uberNetRegion(), 'Config').done(function (data) {
            textStatus('ubernet created game, gonna connect now...');
            data = JSON.parse(data);
            model.lobbyId(data.LobbyID);
            installHandlers(config);
            connectToServer(data);
        }).fail(function (data) {
            textStatus('failed to start ubernet game');
            reset();
        });
    };
    var joinGame = function (lobbyId) {
        textStatus('join ubernet game... ');
        engine.asyncCall('ubernet.joinGame', lobbyId).done(function (data) {
            data = JSON.parse(data);
            if (data.PollWaitTimeMS) {
                console.log('poll', data.PollWaitTimeMS);
                window.setTimeout(function () {
                    joinGame(lobbyId);
                }, 5000);
            } else {
                textStatus('ubernet game join successful, will connect now');
                model.lobbyId(lobbyId);
                connectToServer();
            }
        }).fail(function (data) {
            textStatus('failed to join ubernet game');
            reset();
        });
    };
    var connectToServer = function (data) {
        model.isLocalGame(false);
        model.gameTicket(data.Ticket);
        model.gameHostname(data.ServerHostname);
        model.gamePort(data.ServerPort);
        textStatus('connecting to game...');
        engine.call('join_game', String(data.ServerHostname), Number(data.ServerPort), String(model.displayName()), String(data.Ticket), String(JSON.stringify({ password: undefined })));
    };
    var configure = function (desc) {
        model.send_message('modify_settings', desc, function (success) {
            if (!success) {
                textStatus('modify_settings failed');
                reset();
            }
        });
    };
    var setSystem = function (system) {
        model.send_message('modify_system', system, function (success) {
            if (!success) {
                textStatus('modify_system failed');
                reset();
            }
        });
    };
    var resetArmies = function (armies) {
        model.send_message('reset_armies', armies, function (success) {
            if (!success) {
                textStatus('reset armies failed');
                reset();
            }
        });
    };
    var joinSlot = function (slot) {
        model.send_message('join_army', {
            army: slot,
            commander: { ObjectName: model.preferredCommander().ObjectName }
        });
    };
    var startGame = function () {
        textStatus('starting game');
        model.send_message('start_game', undefined, function (success) {
            if (!success) {
                textStatus('start_game failed');
                reset();
            }
        });
    };
    var states = {
            landing: function (msg) {
                removeHandlers();
                window.location.href = msg.url;
            },
            playing: function (msg) {
                removeHandlers();
                window.location.href = msg.url;
            },
            lobby: function (msg) {
                callerConfiguration(msg);
            }
        };
    var installHandlers = function (config) {
        callerConfiguration = config;
        Object.keys(gameHandlers).forEach(function (handler) {
            panhandler.on(handler, gameHandlers[handler]);
        });
    };
    var removeHandlers = function () {
        Object.keys(gameHandlers).forEach(function (handler) {
            panhandler.off(handler, gameHandlers[handler]);
        });
    };
    var gameHandlers = {
            server_state: function (msg) {
                console.log('server_state');
                console.log(msg);
                if (msg.state != state) {
                    state = msg.state;
                    states[msg.state] && states[msg.state](msg);
                }
            },
            control: function (msg) {
                console.log('control');
                console.log(msg);
                if (msg.sim_ready) {
                    startGame();
                }
            },
            connection_disconnected: function (payload) {
                var message = loc('!LOC(connect_to_game:connection_to_server_lost.message):CONNECTION TO SERVER LOST');
                textStatus(message);
                console.log(payload);
                reset();
            },
            connection_failed: function (payload) {
                var message = loc('!LOC(connect_to_game:connection_to_server_failed.message):CONNECTION TO SERVER FAILED');
                textStatus(message);
                console.log(payload);
                reset();
            },
            login_accepted: function (payload) {
                var message = loc('!LOC(connect_to_game:login_accepted.message):LOGIN ACCEPTED');
                textStatus(message);
                app.hello(gameHandlers.server_state, gameHandlers.connection_disconnected);
            },
            login_rejected: function (payload) {
                var message = loc('!LOC(connect_to_game:login_to_server_rejected.message):LOGIN TO SERVER REJECTED');
                textStatus(message);
                console.log(payload);
                reset();
            }
        };
    return {
        reset: reset,
        publish: publish,
        joinGame: joinGame,
        connectToServer: connectToServer,
        configure: configure,
        setSystem: setSystem,
        resetArmies: resetArmies,
        joinSlot: joinSlot,
        startGame: startGame,
        textStatus: textStatus
    };
}();
instant_sandbox['instant_sandbox_defaults'] = function () {
    var FreeForAll = '0';
    var TeamArmies = '1';
    var Alliance = '2';
    var VersusAi = '3';
    var Code = 'code';
    var Settings = 'settings';
    return {
        config: Code,
        settings: {
            type: FreeForAll,
            spectators: 0,
            blocked: [],
            public: false,
            friends: [],
            password: undefined
        },
        armies: [
            {
                'slots': 1,
                ai: false,
                alliance: false
            },
            {
                'slots': 1,
                ai: true,
                alliance: false,
                economy_factor: -1
            }
        ],
        system: {
            'name': 'Instant Sandbox System',
            'planets': [{
                    'name': 'Small Moon',
                    'mass': 10000,
                    'position_x': 53567.4,
                    'position_y': 8786.55,
                    'velocity_x': -15.5348,
                    'velocity_y': 94.7081,
                    'planet': {
                        'seed': 78462,
                        'radius': 400,
                        'heightRange': 75,
                        'waterHeight': 0,
                        'temperature': 0,
                        'metalDensity': 50,
                        'metalClusters': 50,
                        'biomeScale': 50,
                        'biome': 'sandbox'
                    }
                }]
        }
    };
}();
instant_sandbox['instant_sandbox_config'] = function (defaults) {
    if (defaults.config == 'code') {
        return defaults;
    }
    initialSettingValue('instant_standbox_ai_armies', 1);
    initialSettingValue('instant_standbox_ai_slots', 1);
    initialSettingValue('instant_standbox_ai_economy', 0);
    var settings = decode(localStorage.settings);
    var config = {
            settings: defaults.settings,
            armies: [{
                    'slots': 1,
                    ai: false,
                    alliance: false
                }],
            system: decode(localStorage.instant_sandbox_system)
        };
    for (var i = 0; i < settings.instant_standbox_ai_armies; i++) {
        config.armies.push({
            slots: settings.instant_standbox_ai_slots,
            ai: true,
            alliance: false,
            economy_factor: settings.instant_standbox_ai_economy / 10
        });
    }
    return config;
}(instant_sandbox['instant_sandbox_defaults']);
instant_sandbox['text'] = {
    load: function (id) {
        throw new Error('Dynamic load not allowed: ' + id);
    }
};
instant_sandbox['text_instant_sandbox_dialoghtml'] = '<div id="instant_sandbox_dialog">\n  <div class="div_alert" >\n    <img src="coui://ui/main/shared/img/loading.gif" class="img_progress_icon" style="margin:0px 8px 0px 0px"></img>\n    <div id="instant_sandbox_msg_progress" class="msg_progress_icon" data-bind="text: instantSandboxProgress"></div>\n  </div>\n</div>\n';
instant_sandbox['instant_sandbox_dialog'] = function (html) {
    
    var viewModel = { instantSandboxProgress: ko.observable('') };
    return {
        open: function (message) {
            var $dialog = $(html);
            ko.applyBindings(viewModel, $dialog[0]);
            $('body').append($dialog);
            $dialog.dialog({
                dialogClass: 'no-close',
                closeOnEscape: false,
                draggable: false,
                resizable: false,
                height: 240,
                width: 600,
                modal: true,
                buttons: {}
            });
            viewModel.instantSandboxProgress(message || 'Working...');
        },
        progress: viewModel.instantSandboxProgress
    };
}(instant_sandbox['text_instant_sandbox_dialoghtml']);
instant_sandbox['instant_sandbox_pastats'] = function () {
    if (window['paStatsGlobal'] == undefined) {
        return {
            setLobby: function (lobbyId) {
            },
            setSystem: function (system) {
            },
            setArmies: function (armies) {
            },
            setPlayer: function (index) {
            }
        };
    }
    console.log('Instant Sandbox: using PAStats setup');
    var rgb = function (triple) {
        if (triple == undefined)
            return '';
        return 'rgb(' + triple[0] + ',' + triple[1] + ',' + triple[2] + ')';
    };
    return {
        setLobby: function (lobbyId) {
            localStorage['lobbyId'] = encode(lobbyId);
            localStorage[paStatsGlobal.isRankedGameKey] = encode(false);
        },
        setSystem: function (system) {
            localStorage['pa_stats_loaded_planet_json'] = JSON.stringify(system);
        },
        setArmies: function (armies) {
            var teams = [];
            armies.forEach(function (army, index) {
                teams.push({
                    index: index,
                    players: army.ai ? [{ displayName: 'AI' }] : [],
                    primaryColor: '',
                    secondaryColor: ''
                });
            });
            localStorage[paStatsGlobal.pa_stats_session_teams] = encode(teams);
        },
        setPlayer: function (index, player) {
            localStorage[paStatsGlobal.pa_stats_session_team_index] = encode(index);
            var teams = decode(localStorage[paStatsGlobal.pa_stats_session_teams]);
            teams[index].primaryColor = rgb(player.color[0]);
            teams[index].secondaryColor = rgb(player.color[1]);
            teams[index].players = [{ displayName: player.name }], console.log(teams);
            localStorage[paStatsGlobal.pa_stats_session_teams] = encode(teams);
        }
    };
}();
instant_sandbox['text_instant_sandbox_buttonhtml'] = '<a href="#" class="nav_item" id="start_instant_sandbox" data-bind="click: startInstantSandbox, click_sound: \'default\', rollover_sound: \'default\', css: { nav_item_disabled: !allowNewOrJoinGame() } ">\n    <span class="nav_item_text" data-bind="css: { nav_item_text_disabled: !allowNewOrJoinGame() }">\n        <loc desc="">INSTANT SANDBOX</loc>\n    </span>\n</a>\n';
instant_sandbox['instant_sandbox_start'] = function (system, game, config, dialog, pastats, html) {
    
    var hasPAStats = function () {
        for (var i in scene_mod_list.start) {
            if (scene_mod_list.start[i].match('pastats/scenes/ranked_matcher')) {
                return true;
            }
        }
        return false;
    };
    var viewModel = {
            allowNewOrJoinGame: model.allowNewOrJoinGame,
            startInstantSandbox: function () {
                dialog.open('Making Sandbox');
                game.publish(gameConfiguration);
            }
        };
    model.startInstantSandbox = viewModel.startInstantSandbox;
    var gameConfiguration = function (msg) {
        dialog.progress('lobby: configure planets...');
        pastats.setLobby(model.lobbyId());
        game.configure(config.settings);
        pastats.setSystem(config.system);
        system.convertClientToServer(config.system);
        game.setSystem(config.system);
        pastats.setArmies(config.armies);
        game.resetArmies(config.armies);
        dialog.progress('lobby: join slot...');
        if (config.armies[0].ai == false) {
            game.joinSlot(0);
            pastats.setPlayer(0, msg.data.players[0]);
        }
        dialog.progress('Generating Planets');
    };
    dialog.progress.subscribe(function (message) {
        console.log(message);
    });
    return {
        ready: function () {
            if (hasPAStats())
                return;
            var $button = $(html);
            $('#navigation_items').append($button);
            ko.applyBindings(viewModel, $button[0]);
            game.textStatus.subscribe(dialog.progress);
        }
    };
}(instant_sandbox['instant_sandbox_system'], instant_sandbox['instant_sandbox_game'], instant_sandbox['instant_sandbox_config'], instant_sandbox['instant_sandbox_dialog'], instant_sandbox['instant_sandbox_pastats'], instant_sandbox['text_instant_sandbox_buttonhtml']);
instant_sandbox['instant_sandbox_main'] = function (start) {
    
    start.ready();
}(instant_sandbox['instant_sandbox_start']);
