var instant_sandbox = {};
instant_sandbox['instant_sandbox_planet'] = {
    convertClientToServer: function (planet) {
        if (planet.hasOwnProperty('position_x')) {
            planet.position = [
                planet.position_x,
                planet.position_y
            ];
            delete planet.position_x;
            delete planet.position_y;
        }
        if (planet.hasOwnProperty('velocity_x')) {
            planet.velocity = [
                planet.velocity_x,
                planet.velocity_y
            ];
            delete planet.velocity_x;
            delete planet.velocity_y;
        }
        if (planet.hasOwnProperty('planet')) {
            planet.generator = planet.planet;
            delete planet.planet;
        }
    },
    convertServerToClient: function (planet) {
        if (planet.hasOwnProperty('position')) {
            planet.position_x = planet.position[0];
            planet.position_y = planet.position[1];
            delete planet.position;
        }
        if (planet.hasOwnProperty('velocity')) {
            planet.velocity_x = planet.velocity[0];
            planet.velocity_y = planet.velocity[1];
            delete planet.velocity;
        }
        if (planet.hasOwnProperty('generator')) {
            planet.planet = planet.generator;
            delete planet.generator;
        }
    }
};
instant_sandbox['instant_sandbox_game_description'] = function (planet) {
    
    var template = {
            'blocked': [],
            'enable_lan': false,
            'public': false,
            'friends': [],
            'password': undefined,
            'spectators': 0,
            'system': null,
            'type': '0'
        };
    return {
        teamTypes: [
            'FreeForAll',
            'TeamArmies',
            'Alliance',
            'VersusAI'
        ],
        convertClientToServer: function (desc) {
            desc.system.planets.forEach(planet.convertClientToServer);
        },
        convertServerToClient: function (desc) {
            desc.system.planets.forEach(planet.convertServerToClient);
        },
        createGame: function (config) {
            var desc = Object.create(template);
            desc.type = config.type;
            desc.system = config.system;
            desc.spectators = config.spectators;
            return desc;
        }
    };
}(instant_sandbox['instant_sandbox_planet']);
instant_sandbox['instant_sandbox_game'] = function () {
    
    var reset = function () {
        engine.call('reset_game_state');
    };
    var publish = function () {
        reset();
        console.log('publish game...');
        console.log('use region: ' + model.uberNetRegion());
        engine.asyncCall('ubernet.startGame', model.uberNetRegion(), 'Config').done(function (data) {
            console.log('ubernet created game, gonna connect now...');
            data = JSON.parse(data);
            model.lobbyId(data.LobbyID);
            connectToServer(data);
        }).fail(function (data) {
            console.log('failed to start ubernet game');
            reset();
        });
    };
    var joinGame = function (lobbyId) {
        console.log('join ubernet game... ');
        engine.asyncCall('ubernet.joinGame', lobbyId).done(function (data) {
            data = JSON.parse(data);
            if (data.PollWaitTimeMS) {
                console.log('poll', data.PollWaitTimeMS);
                window.setTimeout(function () {
                    joinGame(lobbyId);
                }, 5000);
            } else {
                console.log('ubernet game join successful, will connect now');
                model.lobbyId(lobbyId);
                connectToServer();
            }
        }).fail(function (data) {
            console.log('failed to join ubernet game');
            reset();
        });
    };
    var connectToServer = function (data) {
        model.isLocalGame(false);
        model.gameTicket(data.Ticket);
        model.gameHostname(data.ServerHostname);
        model.gamePort(data.ServerPort);
        console.log('connecting to game...');
        engine.call('join_game', String(data.ServerHostname), Number(data.ServerPort), String(model.displayName()), String(data.Ticket), String(JSON.stringify({ password: undefined })));
    };
    var configure = function (desc) {
        model.send_message('update_game_config', desc, function (success) {
            if (!success) {
                console.log('setting planets failed');
                reset();
            }
        });
    };
    var resetArmies = function (armies) {
        model.send_message('reset_armies', armies, function (success) {
            if (!success) {
                console.log('reset armies failed');
                reset();
            }
        });
    };
    var joinSlot = function (slot) {
        model.send_message('join_army', {
            army: slot,
            commander: { ObjectName: model.preferredCommander().ObjectName }
        });
    };
    var startGame = function () {
        console.log('starting game');
        model.send_message('start_game', undefined, function (success) {
            if (!success) {
                console.log('start_game failed');
                reset();
            }
        });
    };
    return {
        reset: reset,
        publish: publish,
        joinGame: joinGame,
        connectToServer: connectToServer,
        configure: configure,
        resetArmies: resetArmies,
        joinSlot: joinSlot,
        startGame: startGame
    };
}();
instant_sandbox['instant_sandbox_defaults'] = function () {
    var FreeForAll = '0';
    var TeamArmies = '1';
    var Alliance = '2';
    var VersusAi = '3';
    return {
        type: FreeForAll,
        armies: [
            {
                'slots': 1,
                ai: false,
                alliance: false
            },
            {
                'slots': 1,
                ai: true,
                alliance: false,
                economy_factor: -1
            }
        ],
        spectators: 0,
        system: {
            'name': 'Just a Small Moon',
            'planets': [{
                    'name': 'Small Moon',
                    'mass': 10000,
                    'position_x': 53567.4,
                    'position_y': 8786.55,
                    'velocity_x': -15.5348,
                    'velocity_y': 94.7081,
                    'planet': {
                        'seed': 78462,
                        'radius': 400,
                        'heightRange': 75,
                        'waterHeight': 0,
                        'temperature': 0,
                        'metalDensity': 50,
                        'metalClusters': 50,
                        'biomeScale': 50,
                        'biome': 'moon'
                    }
                }]
        }
    };
}();
instant_sandbox['text'] = {
    load: function (id) {
        throw new Error('Dynamic load not allowed: ' + id);
    }
};
instant_sandbox['text_instant_sandbox_buttonhtml'] = '<a href="#" class="nav_item" id="start_instant_sandbox" data-bind="click: startInstantSandbox, click_sound: \'default\', rollover_sound: \'default\', css: { nav_item_disabled: !allowNewOrJoinGame() } ">\n    <span class="nav_item_text" data-bind="css: { nav_item_text_disabled: !allowNewOrJoinGame() }">\n        <loc desc="">INSTANT SANDBOX</loc>\n    </span>\n</a>\n';
instant_sandbox['instant_sandbox_start'] = function (description, game, defaults, html) {
    
    var viewModel = {
            allowNewOrJoinGame: model.allowNewOrJoinGame,
            startInstantSandbox: function () {
                game.publish();
            }
        };
    var states = {
            landing: function (msg) {
                window.location.href = msg.url;
            },
            playing: function (msg) {
                window.location.href = msg.url;
            },
            lobby: function (msg) {
                console.log('lobby: configure planets...');
                var desc = description.createGame(defaults);
                description.convertClientToServer(desc);
                game.configure(desc);
                game.resetArmies(defaults.armies);
                console.log('lobby: join slot...');
                if (defaults.armies[0].ai == false) {
                    game.joinSlot(0);
                }
            }
        };
    handlers.connection_failed = function (payload) {
        var message = loc('!LOC(connect_to_game:connection_to_server_failed.message):CONNECTION TO SERVER FAILED');
        console.log(payload, message);
        game.reset();
    };
    handlers.login_accepted = function (payload) {
        var message = loc('!LOC(connect_to_game:login_accepted.message):LOGIN ACCEPTED');
        console.log(message);
        app.hello(handlers.server_state, handlers.connection_disconnected);
    };
    handlers.login_rejected = function (payload) {
        var message = loc('!LOC(connect_to_game:login_to_server_rejected.message):LOGIN TO SERVER REJECTED');
        console.log(payload, message);
        game.reset();
    };
    handlers.connection_disconnected = function (payload) {
        var message = loc('!LOC(connect_to_game:connection_to_server_lost.message):CONNECTION TO SERVER LOST');
        console.log(payload, message);
        game.reset();
    };
    var state = '';
    handlers.server_state = function (msg) {
        console.log('server_state');
        console.log(msg);
        if (msg.state != state) {
            state = msg.state;
            states[msg.state] && states[msg.state](msg);
        }
    };
    handlers.control = function (msg) {
        console.log('control');
        console.log(msg);
        if (msg.sim_ready) {
            game.startGame();
        }
    };
    return {
        ready: function () {
            var $button = $(html);
            $('#navigation_items').append($button);
            ko.applyBindings(viewModel, $button[0]);
        }
    };
}(instant_sandbox['instant_sandbox_game_description'], instant_sandbox['instant_sandbox_game'], instant_sandbox['instant_sandbox_defaults'], instant_sandbox['text_instant_sandbox_buttonhtml']);
instant_sandbox['instant_sandbox_main'] = function (start) {
    
    setTimeout(start.ready, 0);
}(instant_sandbox['instant_sandbox_start']);
