// !LOCNS:galactic_war
define([
    'main/game/galactic_war/shared/js/systems/planets'
    ], function (examplePlanetList) {
    return [
        {
            Players: [0, 2],
            Systems: [
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [375, 425],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [-15000, 0],
                            Velocity: [0, 244],
                            Biomes: [ 'earth', 'desert', 'tropical' ]
                        }
                    ],
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [450, 550],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [0, 100],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [60000, 0],
                            Velocity: [0, -58.1138],
                            Biomes: ['lava', 'moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [38, 42],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [15000, 0],
                            Velocity: [-0.00000798057, 182.574],
                            Biomes: ['desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [38, 42],
                            Temp: [0, 100],
                            MetalDensity: [25, 75],
                            MetalClusters: [25, 50],
                            BiomeScale: [100, 100],
                            Position: [-15000, 0],
                            Velocity: [0.00000798057, -182.574],
                            Biomes: ['desert', 'lava']
                        }
                    ],
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [400, 500],
                            Height: [20, 25],
                            Water: [38, 42],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [25000, 0],
                            Velocity: [-0.000006181723165354924, 141.42135620117188],
                            Biomes: ['desert', 'lava', 'tropical', 'earth']
                        }
                    ],
                },
                {
                    Planets: [
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [375, 400],
                            Height: [20, 25],
                            Water: [32, 34],
                            Temp: [0, 5],
                            MetalDensity: [75, 100],
                            MetalClusters: [75, 100],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [-0.00000437114, 100],
                            Biomes: ['moon', 'earth', 'tropical', 'desert']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [1, 1],
                            Radius: [250, 250],
                            Height: [10, 15],
                            Water: [0, 10],
                            Temp: [0, 10],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [57500, 0],
                            Velocity: [0.000118759, -82.5742],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [1, 1],
                            Radius: [250, 250],
                            Height: [10, 15],
                            Water: [0, 10],
                            Temp: [0, 10],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [42500, 0],
                            Velocity: [0.0000295162, 282.574],
                            Biomes: ['moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [0, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [28700, 0],
                            Velocity: [0, -118.5163],
                            Biomes: ['lava', 'moon', 'earth']
                        },
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [1200, 1200],
                            Height: [0, 0],
                            Water: [0, 0],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [25000, 0],
                            Velocity: [0, 141.4214],
                            Biomes: ['gas']
                        }
                    ]
                }
            ]
        },
        {
            Players: [3, 3],
            Systems: [
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [450, 600],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [-15000, 0],
                            Velocity: [0, 244],
                            Biomes: [ 'earth', 'desert', 'tropical', 'lava', 'moon' ]
                        }
                    ],
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [550, 600],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [0, 100],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [60000, 0],
                            Velocity: [0, -58.1138],
                            Biomes: ['lava', 'moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [15000, 0],
                            Velocity: [-0.00000798057, 182.574],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [-15000, 0],
                            Velocity: [0.00000798057, -182.574],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [0, 15000],
                            Velocity: [-182.574, -0.00000798057],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [15000, 0],
                            Velocity: [-0.00000798057, 182.574],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [-15000, 0],
                            Velocity: [0.00000798057, -182.574],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [0, 15000],
                            Velocity: [-182.574, -0.00000798057],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [1, 3],
                            Radius: [200, 200],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [0, -15000],
                            Velocity: [182.574, 0.00000798057],
                            Biomes: ['moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [15000, 0],
                            Velocity: [-0.00000798057, 182.574],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [-15000, 0],
                            Velocity: [0.00000798057, -182.574],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [0, 15000],
                            Velocity: [-182.574, -0.00000798057],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [1, 3],
                            Radius: [250, 250],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [0, -125000],
                            Velocity: [63.2456, 0.00000276455],
                            Biomes: ['moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [1500, 1500],
                            Height: [0, 0],
                            Water: [0, 0],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [-25000, 0],
                            Velocity: [0, -141.4214],
                            Biomes: ['gas']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [32, 40],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [-20000, 0],
                            Velocity: [0, 82.1854],
                            Biomes: ['moon', 'lava', 'earth', 'desert']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [32, 40],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [-25000, 5000],
                            Velocity: [-223.60679, -141.4213],
                            Biomes: ['moon', 'lava', 'earth', 'desert']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [32, 40],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [-30000, 0],
                            Velocity: [0, -365.02813],
                            Biomes: ['moon', 'lava', 'earth', 'desert']
                        }
                    ],
                },
            ]
        },
        {
            Players: [4, 4],
            Systems: [
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [500, 600],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [-15000, 0],
                            Velocity: [0, 244],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'metal', 'moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [500, 600],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [0, 100],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [60000, 0],
                            Velocity: [0, -58.1138],
                            Biomes: ['lava', 'moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [15000, 0],
                            Velocity: [-0.00000798057, 182.574],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [-15000, 0],
                            Velocity: [0.00000798057, -182.574],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [0, 15000],
                            Velocity: [-182.574, -0.00000798057],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [350, 350],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [0, -15000],
                            Velocity: [182.574, 0.00000798057],
                            Biomes: ['moon', 'earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 4],
                            Radius: [200, 250],
                            Height: [2, 5],
                            Water: [1, 2],
                            Temp: [0, 10],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [100000, 0],
                            Velocity: [-0.00000309086, 70.7107],
                            Biomes: ['moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [700, 700],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [75, 100],
                            MetalClusters: [75, 100],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [-0.00000437114, 100],
                            Biomes: ['earth', 'tropical']
                        },
                        {
                            starting_planet: true,
                            mass: 25000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [20, 24],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [60000, 0],
                            Velocity: [-0.000071654, 258.114],
                            Biomes: ['desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 25000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [20, 24],
                            Temp: [0, 100],
                            MetalDensity: [0, 14],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [40000, 0],
                            Velocity: [-0.0000578313, -58.1139],
                            Biomes: ['desert', 'lava']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [3, 3],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [65000, 0],
                            Velocity: [-0.0000421168, 100],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [3, 3],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [32, 38],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [35000, 0],
                            Velocity: [-0.0000764278, 41.8861],
                            Biomes: ['moon']
                        },
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [600, 600],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [-0.00000437114, 100],
                            Biomes: ['desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [600, 600],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [-50000, 0],
                            Velocity: [0.00000437114, -100],
                            Biomes: ['desert', 'lava']
                        },
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [500, 500],
                            Height: [0, 5],
                            Water: [1, 5],
                            Temp: [0, 100],
                            MetalDensity: [50, 100],
                            MetalClusters: [100, 100],
                            BiomeScale: [100, 100],
                            Position: [0, -100000],
                            Velocity: [70.7107, 0.00000309086],
                            Biomes: ['metal']
                        }
                    ],
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [600, 600],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [-0.00000437114, 100],
                            Biomes: ['desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [600, 600],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [-50000, 0],
                            Velocity: [0.00000437114, -100],
                            Biomes: ['desert', 'lava']
                        },
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [1, 3],
                            Radius: [300, 300],
                            Height: [0, 5],
                            Water: [1, 5],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [0, -100000],
                            Velocity: [70.7107, 0.00000309086],
                            Biomes: ['moon']
                        }
                    ],
                },
                {
                    Planets: [
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [1500, 1500],
                            Height: [0, 0],
                            Water: [0, 0],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [-25000, 0],
                            Velocity: [0, 244],
                            Biomes: ['gas']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [32, 40],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [-20000, 0],
                            Velocity: [0, 365.02813],
                            Biomes: ['moon', 'lava', 'earth', 'desert']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [32, 40],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [-25000, 5000],
                            Velocity: [-223.60679626464844, -141.42137145996094],
                            Biomes: ['moon', 'lava', 'earth', 'desert']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [32, 40],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [-30000, 0],
                            Velocity: [0.000015955887647578493, -365.02813720703125],
                            Biomes: ['moon', 'lava', 'earth', 'desert']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [32, 40],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [-25000, -5000],
                            Velocity: [223.60679626464844, -141.42137145996094],
                            Biomes: ['moon', 'lava', 'earth', 'desert']
                        }
                    ],
                },
                {
                    Planets: [
                       {
                           starting_planet: false,
                           mass: 50000,
                           Thrust: [0, 0],
                           Radius: [1500, 1500],
                           Height: [0, 0],
                           Water: [0, 0],
                           Temp: [0, 100],
                           MetalDensity: [0, 0],
                           MetalClusters: [0, 0],
                           BiomeScale: [0, 0],
                           Position: [30000, 0],
                           Velocity: [0, 129.0994],
                           Biomes: ['gas']
                       },
                       {
                           starting_planet: true,
                           mass: 10000,
                           Thrust: [0, 0],
                           Radius: [450, 550],
                           Height: [10, 25],
                           Water: [0, 45],
                           Temp: [0, 100],
                           MetalDensity: [25, 50],
                           MetalClusters: [0, 24],
                           BiomeScale: [0, 100],
                           Position: [35000, 0],
                           Velocity: [0, -94.5074],
                           Biomes: ['earth', 'lava', 'desert', 'tropical']
                       },
                       {
                           starting_planet: true,
                           mass: 10000,
                           Thrust: [0, 0],
                           Radius: [450, 550],
                           Height: [10, 25],
                           Water: [0, 40],
                           Temp: [0, 100],
                           MetalDensity: [25, 50],
                           MetalClusters: [0, 24],
                           BiomeScale: [0, 100],
                           Position: [25000, 0],
                           Velocity: [0, 352.7061],
                           Biomes: ['earth', 'lava', 'desert', 'tropical']
                       },
                       {
                           starting_planet: true,
                           mass: 5000,
                           Thrust: [1, 3],
                           Radius: [200, 250],
                           Height: [0, 10],
                           Water: [0, 0],
                           Temp: [0, 0],
                           MetalDensity: [10, 20],
                           MetalClusters: [0, 24],
                           BiomeScale: [0, 100],
                           Position: [20000, 0],
                           Velocity: [0, 287.213287],
                           Biomes: ['moon', 'lava']
                       },
                       {
                           starting_planet: false,
                           mass: 50000,
                           Thrust: [0, 0],
                           Radius: [500, 525],
                           Height: [0, 0],
                           Water: [0, 0],
                           Temp: [0, 100],
                           MetalDensity: [50, 100],
                           MetalClusters: [50, 100],
                           BiomeScale: [0, 100],
                           Position: [14000, 0],
                           Velocity: [0, 188.98223],
                           Biomes: ['metal']
                       }
                    ]
                }
            ]
        },
        {
            Players: [5, 5],
            Systems: [
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [600, 800],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [-15000, 0],
                            Velocity: [0, 244],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'metal', 'moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [600, 800],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [0, 100],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [60000, 0],
                            Velocity: [0, -58.1138],
                            Biomes: ['lava', 'moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [5, 5],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [0, 25000],
                            Velocity: [-141.421, -0.00000618172],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'moon']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [5, 5],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [23800, 7700],
                            Velocity: [-43.5197, 134.515],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'moon']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [5, 5],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [14700, -20200],
                            Velocity: [-114.388, 83.2427],
                            Biomes: ['earth', 'desert', 'lava', 'moon']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [5, 5],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [-14700, -20200],
                            Velocity: [114.388, 83.2427],
                            Biomes: ['earth', 'desert', 'lava', 'moon']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [5, 5],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [-23800, 7700],
                            Velocity: [-43.5197, -134.515],
                            Biomes: ['earth', 'desert', 'lava', 'moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [600, 600],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [100, 100],
                            MetalClusters: [100, 100],
                            BiomeScale: [100, 100],
                            Position: [100000, 0],
                            Velocity: [-0.00000309086, 70.7107],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'metal']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [3, 3],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [100000, -10000],
                            Velocity: [158.114, -70.7105],
                            Biomes: ['earth', 'lava', 'moon']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [3, 3],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [90500, -3100],
                            Velocity: [49.0675, -221.076],
                            Biomes: ['earth', 'lava', 'moon']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [3, 3],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [94100, 8100],
                            Velocity: [-127.67, -163.706],
                            Biomes: ['earth', 'lava', 'moon']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [3, 3],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [105900, 8100],
                            Velocity: [-127.67, 22.2842],
                            Biomes: ['earth', 'lava', 'moon']
                        },
                        {
                            starting_planet: true,
                            mass: 5000,
                            Thrust: [3, 3],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [105900, -3100],
                            Velocity: [49.0677, 79.6551],
                            Biomes: ['earth', 'lava', 'moon']
                        },
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [1000, 1000],
                            Height: [20, 25],
                            Water: [50, 60],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [40000, 0],
                            Velocity: [0, 111.803],
                            Biomes: ['earth', 'desert']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [0, 0],
                            Radius: [1000, 1000],
                            Height: [0, 0],
                            Water: [0, 0],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [40000, -5000],
                            Velocity: [-141.421, 111.803],
                            Biomes: ['gas']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [0, 0],
                            Radius: [1000, 1000],
                            Height: [0, 0],
                            Water: [0, 0],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [35700, 2500],
                            Velocity: [116.033, 334.6165],
                            Biomes: ['gas']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [0, 0],
                            Radius: [1000, 1000],
                            Height: [0, 0],
                            Water: [0, 0],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [44300, 2500],
                            Velocity: [116.034, -53.0185],
                            Biomes: ['gas']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [650, 800],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [0, 100],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [60000, 0],
                            Velocity: [0, -58.1138],
                            Biomes: ['lava', 'moon']
                        },
                        {
                             starting_planet: false,
                             mass: 50000,
                             Thrust: [0, 0],
                             Radius: [1500, 1500],
                             Height: [0, 0],
                             Water: [0, 0],
                             Temp: [0, 100],
                             MetalDensity: [0, 0],
                             MetalClusters: [0, 0],
                             BiomeScale: [100, 100],
                             Position: [-25000, 0],
                             Velocity: [0, -141.4213],
                             Biomes: ['gas']
                         },
                    ]
                },
            ]
        },
        {
            Players: [6, 8],
            Systems: [
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [700, 900],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [75, 100],
                            MetalClusters: [75, 100],
                            BiomeScale: [100, 100],
                            Position: [-15000, 0],
                            Velocity: [0, 244],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'metal', 'moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [800, 1000],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [0, 100],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [60000, 0],
                            Velocity: [0, -58.1138],
                            Biomes: ['lava', 'moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [550, 600],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [0, 100],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [60000, 0],
                            Velocity: [0, -58.1138],
                            Biomes: ['lava', 'moon']
                        },
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [1500, 1500],
                            Height: [0, 0],
                            Water: [0, 0],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [-25000, 0],
                            Velocity: [0, -141.4213],
                            Biomes: ['gas']
                        },
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [25000, 0],
                            Velocity: [0.00000618172, -141.421],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [12500, -21700],
                            Velocity: [-122.439, -70.5296],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [-12500, -21700],
                            Velocity: [-122.439, 70.5296],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [-25000, 0],
                            Velocity: [-0.00000618172, 141.421],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [-12500, 21700],
                            Velocity: [122.439, 70.5297],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [400, 400],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [12500, 21700],
                            Velocity: [122.439, -70.5297],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [500, 600],
                            Height: [0, 1],
                            Water: [0, 1],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 50],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [-0.00000437114, 100],
                            Biomes: ['metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 1],
                            Water: [0, 1],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [55000, 0],
                            Velocity: [-0.000200886, 323.607],
                            Biomes: ['moon', 'lava']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 1],
                            Water: [0, 1],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [45000, 0],
                            Velocity: [-0.000181338, -123.607],
                            Biomes: ['moon', 'lava']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [250, 250],
                            Height: [0, 0],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [100, 100],
                            MetalClusters: [100, 100],
                            BiomeScale: [100, 100],
                            Position: [25000, 0],
                            Velocity: [0.00000618172, -141.421],
                            Biomes: ['moon', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 10000,
                            Thrust: [0, 0],
                            Radius: [600, 600],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [25000, 5000],
                            Velocity: [223.607, -141.421],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 10000,
                            Thrust: [0, 0],
                            Radius: [600, 600],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [29300, -2500],
                            Velocity: [-112.683, -335.237],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 10000,
                            Thrust: [0, 0],
                            Radius: [600, 600],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [20700, -2500],
                            Velocity: [-112.683, 52.3943],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 25],
                            Water: [0, 1],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [0, -50000],
                            Velocity: [100, 0.00000437114],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 25],
                            Water: [0, 1],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [-43300, 25000],
                            Velocity: [-50.0017, -86.6029],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 25],
                            Water: [0, 1],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [43300, 25000],
                            Velocity: [-50.0017, 86.6029],
                            Biomes: ['moon']
                        },
                    ]
                },
                {
                    Planets: [
                       {
                           starting_planet: false,
                           mass: 50000,
                           Thrust: [0, 0],
                           Radius: [1500, 1500],
                           Height: [0, 0],
                           Water: [0, 0],
                           Temp: [0, 100],
                           MetalDensity: [0, 0],
                           MetalClusters: [0, 0],
                           BiomeScale: [0, 0],
                           Position: [30000, 0],
                           Velocity: [0, 129.0994],
                           Biomes: ['gas']
                       },
                       {
                           starting_planet: true,
                           mass: 10000,
                           Thrust: [0, 0],
                           Radius: [450, 550],
                           Height: [10, 25],
                           Water: [0, 45],
                           Temp: [0, 100],
                           MetalDensity: [25, 50],
                           MetalClusters: [0, 24],
                           BiomeScale: [0, 100],
                           Position: [35000, 0],
                           Velocity: [0, -94.5074],
                           Biomes: ['earth', 'lava', 'desert', 'tropical']
                       },
                       {
                           starting_planet: true,
                           mass: 10000,
                           Thrust: [0, 0],
                           Radius: [450, 550],
                           Height: [10, 25],
                           Water: [0, 40],
                           Temp: [0, 100],
                           MetalDensity: [25, 50],
                           MetalClusters: [0, 24],
                           BiomeScale: [0, 100],
                           Position: [25000, 0],
                           Velocity: [0, 352.7061],
                           Biomes: ['earth', 'lava', 'desert', 'tropical']
                       },
                       {
                           starting_planet: true,
                           mass: 5000,
                           Thrust: [1, 3],
                           Radius: [200, 250],
                           Height: [0, 10],
                           Water: [0, 0],
                           Temp: [0, 0],
                           MetalDensity: [10, 20],
                           MetalClusters: [0, 24],
                           BiomeScale: [0, 100],
                           Position: [20000, 0],
                           Velocity: [0, 287.213287],
                           Biomes: ['moon', 'lava']
                       },
                       {
                           starting_planet: false,
                           mass: 50000,
                           Thrust: [0, 0],
                           Radius: [500, 525],
                           Height: [0, 0],
                           Water: [0, 0],
                           Temp: [0, 100],
                           MetalDensity: [50, 100],
                           MetalClusters: [50, 100],
                           BiomeScale: [0, 100],
                           Position: [14000, 0],
                           Velocity: [0, 188.98223],
                           Biomes: ['metal']
                       }
                    ]
                }
            ]
        },
        {
            Players: [9, 10],
            Systems: [
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [900, 1200],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [-15000, 0],
                            Velocity: [0, 244],
                            Biomes: ['earth', 'desert', 'lava', 'metal', 'moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [900, 1000],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [0, 100],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [60000, 0],
                            Velocity: [0, -58.1138],
                            Biomes: ['lava', 'moon']
                        }
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [800, 1000],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 24],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [0, 100],
                            Biomes: ['earth', 'desert', 'tropical', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [60000, 0],
                            Velocity: [0, -58.1138],
                            Biomes: ['lava', 'moon']
                        },
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [1500, 1500],
                            Height: [0, 0],
                            Water: [0, 0],
                            Temp: [0, 100],
                            MetalDensity: [0, 0],
                            MetalClusters: [0, 0],
                            BiomeScale: [100, 100],
                            Position: [-25000, 0],
                            Velocity: [0, -141.4213],
                            Biomes: ['gas']
                        },
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [900, 1000],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 50],
                            BiomeScale: [100, 100],
                            Position: [0, 25000],
                            Velocity: [-141.421, -0.00000618172],
                            Biomes: ['earth', 'desert', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [10, 20],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [-0.00000437114, 100],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [10, 20],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [35400, -35400],
                            Velocity: [70.6661, 70.6661],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [10, 20],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [0, -50000],
                            Velocity: [100, 0.00000437114],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [10, 20],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [-35400, -35400],
                            Velocity: [70.6661, -70.6661],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [10, 20],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [-50000, 0],
                            Velocity: [0.00000437114, -100],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [10, 20],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [-35400, 35400],
                            Velocity: [-70.6661, -70.6661],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [10, 20],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [0, 50000],
                            Velocity: [-100, -0.00000437114],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [10, 20],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [35400, 35400],
                            Velocity: [-70.6661, 70.6661],
                            Biomes: ['moon']
                        },
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [900, 1000],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 50],
                            BiomeScale: [100, 100],
                            Position: [0, 25000],
                            Velocity: [-141.421, -0.00000618172],
                            Biomes: ['earth', 'desert', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: true,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [900, 1000],
                            Height: [20, 25],
                            Water: [33, 35],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [25, 50],
                            BiomeScale: [100, 100],
                            Position: [0, -25000],
                            Velocity: [141.421, 0.00000618172],
                            Biomes: ['earth', 'desert', 'lava', 'moon', 'metal']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [10, 20],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [50000, 0],
                            Velocity: [-0.00000437114, 100],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 10],
                            Water: [1, 2],
                            Temp: [0, 100],
                            MetalDensity: [10, 20],
                            MetalClusters: [0, 49],
                            BiomeScale: [100, 100],
                            Position: [-50000, 0],
                            Velocity: [0.00000437114, -100],
                            Biomes: ['moon']
                        },
                    ]
                },
                {
                    Planets: [
                        {
                            starting_planet: false,
                            mass: 50000,
                            Thrust: [0, 0],
                            Radius: [250, 250],
                            Height: [0, 0],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [100, 100],
                            MetalClusters: [100, 100],
                            BiomeScale: [100, 100],
                            Position: [25000, 0],
                            Velocity: [0.00000618172, -141.421],
                            Biomes: ['moon', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 10000,
                            Thrust: [0, 0],
                            Radius: [600, 600],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [25000, 5000],
                            Velocity: [223.607, -141.421],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 10000,
                            Thrust: [0, 0],
                            Radius: [600, 600],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [29300, -2500],
                            Velocity: [-112.683, -335.237],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: true,
                            mass: 10000,
                            Thrust: [0, 0],
                            Radius: [600, 600],
                            Height: [20, 25],
                            Water: [30, 40],
                            Temp: [0, 100],
                            MetalDensity: [0, 10],
                            MetalClusters: [25, 25],
                            BiomeScale: [100, 100],
                            Position: [20700, -2500],
                            Velocity: [-112.683, 52.3943],
                            Biomes: ['earth', 'desert', 'lava']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 25],
                            Water: [0, 1],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [0, -50000],
                            Velocity: [100, 0.00000437114],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 25],
                            Water: [0, 1],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [-43300, 25000],
                            Velocity: [-50.0017, -86.6029],
                            Biomes: ['moon']
                        },
                        {
                            starting_planet: false,
                            mass: 5000,
                            Thrust: [1, 3],
                            Radius: [200, 250],
                            Height: [0, 25],
                            Water: [0, 1],
                            Temp: [0, 100],
                            MetalDensity: [25, 50],
                            MetalClusters: [0, 25],
                            BiomeScale: [100, 100],
                            Position: [43300, 25000],
                            Velocity: [-50.0017, 86.6029],
                            Biomes: ['moon']
                        },
                    ]
                }
            ]
        }

    ];
});
