var gross_economy = {};
gross_economy['gross_economy_series'] = function (value, scale) {
    var valueHistory = [];
    var timeHistory = [];
    var s = {
            scale: scale,
            value: value,
            percent: ko.computed(function () {
                return '' + 100 * value() / scale() + '%';
            }),
            max: ko.observable(0),
            min: ko.observable(1000000000)
        };
    value.subscribe(function (v) {
        var t = Date.now();
        valueHistory.push(v);
        timeHistory.push(t);
        while (timeHistory.length > 0 && t - timeHistory[0] > 30000) {
            valueHistory.shift();
            timeHistory.shift();
        }
        s.max(Math.max.apply(Math, valueHistory));
        s.min(Math.min.apply(Math, valueHistory));
    });
    s.rangeStart = ko.computed(function () {
        return '' + 100 * s.min() / scale() + '%';
    });
    s.rangeEnd = ko.computed(function () {
        return '' + 100 * (Math.min(scale(), s.max()) - s.min()) / scale() + '%';
    });
    return s;
};
gross_economy['gross_economy_resource'] = function (series) {
    var tickColor = function (weight) {
        return 'rgba(255, 255, 255, ' + weight + ')';
    };
    return function (resource) {
        switch (api.settings.isSet('ui', 'gross_economy_resource_net', true)) {
        default:
        case 'BASIC FABBER SECONDS':
            resource.netString = resource.netStringBfs;
            break;
        case 'PERCENT':
        case 'EFFICIENCY':
            resource.netString = resource.efficiencyString;
            break;
        case 'SIMPLE':
            resource.netString = resource.netStringStock;
            break;
        }
        var currentBfs = ko.computed(function () {
                return Math.round(resource.current() / resource.tick);
            });
        switch (api.settings.isSet('ui', 'gross_economy_resource_storage', true)) {
        case 'BASIC FABBER SECONDS':
            resource.currentString = currentBfs;
            break;
        case 'PERCENT':
            resource.currentString = resource.fractionString;
            break;
        default:
        case 'SIMPLE':
            break;
        }
        resource.scale = ko.computed(function () {
            if (resource.loss) {
                return Math.max(resource.min, resource.currentGain() * 2, resource.currentLoss(), resource.gain.max() * 2, resource.loss.max());
            } else {
                return Math.max(resource.min, resource.currentGain() * 2, resource.currentLoss());
            }
        });
        resource.gain = series(resource.currentGain, resource.scale);
        resource.loss = series(resource.currentLoss, resource.scale);
        resource.ticks = ko.computed(function () {
            var s = resource.scale();
            var axis = [];
            var dx = resource.tick;
            var w1 = Math.sqrt(dx / s);
            while (w1 < 0.15) {
                dx = dx * 5;
                w1 = Math.sqrt(dx / s);
            }
            var w2 = Math.sqrt(5 * dx / s);
            var w3 = Math.sqrt(25 * dx / s);
            var c1 = tickColor(w1);
            var c2 = tickColor(w2);
            var c3 = tickColor(w3);
            for (var x = 0, i = 0; x < s; x += dx, i += 1) {
                if (i % 25 == 0) {
                    axis.push({
                        x: '' + 100 * x / s + '%',
                        color: c3
                    });
                } else if (i % 5 == 0) {
                    axis.push({
                        x: '' + 100 * x / s + '%',
                        color: c2
                    });
                } else {
                    axis.push({
                        x: '' + 100 * x / s + '%',
                        color: c1
                    });
                }
            }
            return axis;
        });
        resource.ratio = ko.computed(function () {
            if (resource.current() > 1) {
                return 1;
            }
            var denom = resource.currentLoss();
            if (denom < 1) {
                denom = 1;
            }
            return resource.currentGain() / denom;
        });
        resource.colorCalculated = ko.computed(function () {
            var storage = resource.current() / resource.max();
            var denom = resource.currentLoss();
            if (denom < 1) {
                denom = 1;
            }
            var ratio = resource.currentGain() / denom;
            return 'rate-' + resource.judgement(storage, ratio);
        });
        resource.coloration = ko.observable();
        resource.colorCalculated.subscribe(resource.coloration);
        resource.coloration.subscribe(function (value) {
            if (resource.$parent) {
                resource.$parent.attr('class', 'contents ' + value);
            }
        });
        var zero = function () {
            return 0;
        };
        var unit_loss = resource.currentLoss;
        var unit_toStorage = ko.computed(function () {
                var net = Math.max(0, resource.currentGain() - resource.currentLoss() + resource.shared());
                return Math.min(net, resource.max() - resource.current());
            });
        var unit_toSharing = ko.computed(function () {
                return Math.max(0, -resource.shared());
            });
        var unit_gain = resource.currentGain;
        var unit_fromSharing = ko.computed(function () {
                return Math.max(0, resource.shared());
            });
        var unit_fromStorage = ko.computed(function () {
                var net = Math.max(0, resource.currentLoss() - resource.currentGain() - resource.shared());
                return Math.min(net, resource.current());
            });
        var per_loss = ko.computed(function () {
                return '' + 100 * unit_loss() / resource.scale() + '%';
            });
        var per_toStorage = ko.computed(function () {
                return '' + 100 * unit_toStorage() / resource.scale() + '%';
            });
        var per_toSharingBase = ko.computed(function () {
                return '' + 100 * (unit_loss() + unit_toStorage()) / resource.scale() + '%';
            });
        var per_toSharing = ko.computed(function () {
                return '' + 100 * unit_toSharing() / resource.scale() + '%';
            });
        var per_gain = ko.computed(function () {
                return '' + 100 * unit_gain() / resource.scale() + '%';
            });
        var per_fromSharing = ko.computed(function () {
                return '' + 100 * unit_fromSharing() / resource.scale() + '%';
            });
        var per_fromStorageBase = ko.computed(function () {
                return '' + 100 * (unit_gain() + unit_fromSharing()) / resource.scale() + '%';
            });
        var per_fromStorage = ko.computed(function () {
                return '' + 100 * unit_fromStorage() / resource.scale() + '%';
            });
        resource.bars = [
            {
                name: 'ge-bar-range',
                tooltip: '30s range',
                left: resource.loss.rangeStart,
                width: resource.loss.rangeEnd
            },
            {
                name: 'ge-bar-loss',
                tooltip: resource.resource + ' expended',
                left: zero,
                width: per_loss
            },
            {
                name: 'ge-bar-to-storage',
                tooltip: resource.resource + ' to storage',
                left: per_loss,
                width: per_toStorage
            },
            {
                name: 'ge-bar-to-sharing',
                tooltip: resource.resource + ' to allies',
                left: per_toSharingBase,
                width: per_toSharing
            },
            {
                name: 'ge-bar-gain',
                tooltip: resource.resource + ' produced',
                left: zero,
                width: per_gain
            },
            {
                name: 'ge-bar-from-sharing',
                tooltip: resource.resource + ' from allies',
                left: per_gain,
                width: per_fromSharing
            },
            {
                name: 'ge-bar-from-storage',
                tooltip: resource.resource + ' from storage',
                left: per_fromStorageBase,
                width: per_fromStorage
            }
        ];
    };
}(gross_economy['gross_economy_series']);
gross_economy['gross_economy_judgement'] = {
    metal: function (storage, ratio) {
        if (storage > 0.99) {
            return 'wasted';
        } else if (storage > 0) {
            return 'good';
        } else {
            if (ratio > 0.75) {
                return 'good';
            } else if (ratio > 0.5) {
                return 'warning';
            } else if (ratio > 0.33) {
                return 'danger';
            } else {
                return 'critical';
            }
        }
    },
    energy: function (storage, ratio) {
        if (storage > 0.99) {
            if (ratio > 1.5) {
                return 'wasted';
            } else if (ratio > 1.1) {
                return 'good';
            } else {
                return 'warning';
            }
        } else if (storage > 0) {
            if (ratio >= 1) {
                return 'warning';
            } else {
                return 'danger';
            }
        } else {
            if (ratio > 0.9) {
                return 'danger';
            } else {
                return 'critical';
            }
        }
    }
};
gross_economy['text'] = {
    load: function (id) {
        throw new Error('Dynamic load not allowed: ' + id);
    }
};
gross_economy['text_gross_economy_status_bar_resourcehtml'] = '<div class="ge-icon-segment" data-bind="css: {\'economic-stall\': ratio() < 1}, tooltip: resource" data-placement="bottom">\n  <div class="ge-icon-background">\n    <div class="ge-category-icon"></div>\n  </div>\n</div>\n<div class="ge-bar-segment">\n  <div class="ge-bar-ticks" data-bind="foreach: ticks">\n    <div class="ge-tick" data-bind="style: {left: x, borderColor: color}"></div>\n  </div>\n  <div class="ge-bar-frame" data-bind="foreach: bars">\n    <div data-bind="attr: {class: name}, style: { left: left, width: width}, tooltip: tooltip" data-placement="bottom"></div>\n  </div>\n</div>\n<div class="ge-gross-segment">\n  <div class="ge-gross-demand" data-bind="text: currentLossString, tooltip: resource + \' expended\'" data-placement="bottom">-8888</div>\n  <div class="ge-gross-supply" data-bind="text: currentGainString, tooltip: resource + \' produced\'" data-placement="bottom">+8888</div>\n</div>\n<div class="ge-net-segment" data-bind="css: {\'economic-limit\': limit() == resource}, tooltip: \'net \' + resource + \' INCOME\'" data-placement="bottom">\n  <div class="ge-net" data-bind="text: netString">+8888</div>\n</div>\n<div class="ge-storage-segment" data-bind="tooltip: resource + \' storage\'" data-placement="bottom">\n  <div class="ge-storage-frame">\n    <div class="ge-storage-fill" data-bind="style: { height: fractionString() }"></div>\n    <div class="ge-storage-number">\n      <span data-bind="text: currentString">8888</span>\n    </div>\n  </div>\n</div>\n';
gross_economy['gross_economy_status_bar'] = function (extendResource, judgement, html) {
    
    var metal = {
            resource: 'metal',
            current: model.currentMetal,
            currentString: model.currentMetalString,
            max: model.maxMetal,
            currentGain: model.metalGain,
            currentGainString: model.metalGainString,
            currentLoss: model.metalLoss,
            currentLossString: model.metalLossString,
            net: model.metalNet,
            netStringStock: model.metalNetString,
            netStringBfs: ko.computed(function () {
                return (model.metalNet() > 0 ? '+' : '') + Math.round(model.metalNet() / 10);
            }),
            efficiencyString: model.metalEfficiencyPercString,
            fractionString: ko.computed(function () {
                return '' + (100 * model.metalFraction()).toFixed(0) + '%';
            }),
            shared: model.metalShared,
            min: 20,
            tick: 10,
            judgement: judgement.metal
        };
    var energy = {
            resource: 'energy',
            current: model.currentEnergy,
            currentString: model.currentEnergyString,
            max: model.maxEnergy,
            currentGain: model.energyGain,
            currentGainString: model.energyGainString,
            currentLoss: model.energyLoss,
            currentLossString: model.energyLossString,
            net: model.energyNet,
            netStringStock: model.energyNetString,
            netStringBfs: ko.computed(function () {
                return (model.energyNet() > 0 ? '+' : '') + Math.round(model.energyNet() / 1000);
            }),
            efficiencyString: model.energyEfficiencyPercString,
            fractionString: ko.computed(function () {
                return '' + (100 * model.energyFraction()).toFixed(0) + '%';
            }),
            shared: model.energyShared,
            min: 2000,
            tick: 1000,
            judgement: judgement.energy
        };
    extendResource(metal);
    extendResource(energy);
    var limit = metal.limit = energy.limit = ko.computed(function () {
            if (metal.ratio() < 1) {
                return 'metal';
            } else if (energy.ratio() < 1) {
                return 'energy';
            } else {
                return 'none';
            }
        });
    var effColorCalculated = ko.computed(function () {
            if (energy.ratio() < metal.ratio()) {
                return energy.coloration();
            } else {
                return metal.coloration();
            }
        });
    var effColoration = ko.observable();
    effColorCalculated.subscribe(effColoration);
    var $eff;
    effColoration.subscribe(function (value) {
        if ($eff) {
            $eff.attr('class', 'gross-economy-eff ' + value);
        }
    });
    var theme = function () {
        switch (api.settings.isSet('ui', 'gross_economy_theme', true)) {
        default:
        case 'INVERSE':
            return 'ge-color-inverse';
        case 'CLASSIC BLACK':
            return 'ge-color-black';
        }
    };
    var installTemplate = function ($parent, html, model) {
        $parent.parent().attr('class', model.resource + ' receiveMouse');
        $parent.html(html);
        model.$parent = $parent;
        ko.applyBindings(model, $parent[0]);
    };
    return {
        ready: function () {
            console.log('Gross Economy ready, modifing status bar');
            installTemplate($('.div-metal .contents'), html, metal);
            installTemplate($('.div-energy .contents'), html, energy);
            $eff = $('.div-eff').attr('class', 'gross-economy-eff');
            $('.div-econ-bar').attr('class', 'gross-economy-bar ignoreMouse ' + theme());
        },
        metal: metal,
        energy: energy
    };
}(gross_economy['gross_economy_resource'], gross_economy['gross_economy_judgement'], gross_economy['text_gross_economy_status_bar_resourcehtml']);
gross_economy['gross_economy_main'] = function (status_bar) {
    
    $(status_bar.ready);
}(gross_economy['gross_economy_status_bar']);
