var gross_economy = {};
gross_economy['gross_economy_series'] = function (value, scale) {
    var valueHistory = [];
    var timeHistory = [];
    var s = {
            scale: scale,
            value: value,
            percent: ko.computed(function () {
                return '' + 100 * value() / scale() + '%';
            }),
            max: ko.observable(0),
            min: ko.observable(1000000000)
        };
    value.subscribe(function (v) {
        var t = Date.now();
        valueHistory.push(v);
        timeHistory.push(t);
        while (timeHistory.length > 0 && t - timeHistory[0] > 30000) {
            valueHistory.shift();
            timeHistory.shift();
        }
        s.max(Math.max.apply(Math, valueHistory));
        s.min(Math.min.apply(Math, valueHistory));
    });
    s.rangeStart = ko.computed(function () {
        return '' + 100 * s.min() / scale() + '%';
    });
    s.rangeEnd = ko.computed(function () {
        return '' + 100 * (Math.min(scale(), s.max()) - s.min()) / scale() + '%';
    });
    return s;
};
gross_economy['gross_economy_resource'] = function (series) {
    var tickColor = function (weight) {
        return 'rgba(255, 255, 255, ' + weight + ')';
    };
    return function (resource, settings) {
        switch (settings.gross_economy_resource_net) {
        default:
        case 'BASIC FABBER SECONDS':
            resource.netString = resource.netStringBfs;
            break;
        case 'PERCENT':
            resource.netString = resource.fractionString;
            break;
        case 'SIMPLE':
            resource.netString = resource.netStringStock;
            break;
        }
        resource.currentBfs = ko.computed(function () {
            return Math.round(resource.current() / resource.tick);
        });
        resource.scale = ko.computed(function () {
            if (resource.loss) {
                return Math.max(resource.min, resource.currentGain() * 2, resource.currentLoss(), resource.gain.max() * 2, resource.loss.max());
            } else {
                return Math.max(resource.min, resource.currentGain() * 2, resource.currentLoss());
            }
        });
        resource.ticks = ko.computed(function () {
            var s = resource.scale();
            var axis = [];
            var dx = resource.tick;
            var w1 = Math.sqrt(dx / s);
            while (w1 < 0.15) {
                dx = dx * 5;
                w1 = Math.sqrt(dx / s);
            }
            var w2 = Math.sqrt(5 * dx / s);
            var w3 = Math.sqrt(25 * dx / s);
            var c1 = tickColor(w1);
            var c2 = tickColor(w2);
            var c3 = tickColor(w3);
            for (var x = 0, i = 0; x < s; x += dx, i += 1) {
                if (i % 25 == 0) {
                    axis.push({
                        x: '' + 100 * x / s + '%',
                        color: c3
                    });
                } else if (i % 5 == 0) {
                    axis.push({
                        x: '' + 100 * x / s + '%',
                        color: c2
                    });
                } else {
                    axis.push({
                        x: '' + 100 * x / s + '%',
                        color: c1
                    });
                }
            }
            return axis;
        });
        resource.ratio = ko.computed(function () {
            if (resource.current() > 1) {
                return 1;
            }
            var denom = resource.currentLoss();
            if (denom < 1) {
                denom = 1;
            }
            return resource.currentGain() / denom;
        });
        resource.toStorage = ko.computed(function () {
            var net = Math.max(0, resource.currentGain() - resource.currentLoss());
            net = Math.min(net, resource.max() - resource.current());
            return '' + 100 * net / resource.scale() + '%';
        });
        resource.fromStorage = ko.computed(function () {
            var net = Math.max(0, resource.currentLoss() - resource.currentGain());
            net = Math.min(net, resource.current());
            return '' + 100 * net / resource.scale() + '%';
        });
        resource.colorCalculated = ko.computed(function () {
            var storage = resource.current() / resource.max();
            var denom = resource.currentLoss();
            if (denom < 1) {
                denom = 1;
            }
            var ratio = resource.currentGain() / denom;
            return 'rate_' + resource.judgement(storage, ratio);
        });
        resource.coloration = ko.observable();
        resource.colorCalculated.subscribe(resource.coloration);
        resource.coloration.subscribe(function (value) {
            if (resource.$parent) {
                resource.$parent.attr('class', 'div_status_bar_cont ' + value);
            }
        });
        resource.gain = series(resource.currentGain, resource.scale);
        resource.loss = series(resource.currentLoss, resource.scale);
    };
}(gross_economy['gross_economy_series']);
gross_economy['gross_economy_judgement'] = {
    metal: function (storage, ratio) {
        if (storage > 0.99) {
            return 'wasted';
        } else if (storage > 0) {
            return 'good';
        } else {
            if (ratio > 0.75) {
                return 'good';
            } else if (ratio > 0.5) {
                return 'warning';
            } else if (ratio > 0.33) {
                return 'danger';
            } else {
                return 'critical';
            }
        }
    },
    energy: function (storage, ratio) {
        if (storage > 0.99) {
            if (ratio > 1.5) {
                return 'wasted';
            } else if (ratio > 1.1) {
                return 'good';
            } else {
                return 'warning';
            }
        } else if (storage > 0) {
            if (ratio >= 1) {
                return 'warning';
            } else {
                return 'danger';
            }
        } else {
            if (ratio > 0.9) {
                return 'danger';
            } else {
                return 'critical';
            }
        }
    }
};
gross_economy['text'] = {
    load: function (id) {
        throw new Error('Dynamic load not allowed: ' + id);
    }
};
gross_economy['text_gross_economy_status_bar_resourcehtml'] = '<td>\n  <div class="icon_frame" data-bind="css: {economic_stall: ratio() < 1}">\n    <div class="category_icon">\n    </div>\n  </div>\n</td>\n<td>\n    <div class="div_status_bar_display">\n        <div class="status_bar_ticks" data-bind="foreach: ticks">\n          <div class="status_bar_tick" data-bind="style: {left: x, borderColor: color}"></div>\n        </div>\n        <div class="status_bar_frame_gross">\n            <div class="status_bar_range" data-bind="style: { left: loss.rangeStart, width: loss.rangeEnd}"></div>\n            <div class="status_bar_loss" data-bind="style: { width: loss.percent() }"> </div>\n            <div class="status_bar_to_storage" data-bind="style: { left: loss.percent(), width: toStorage() }"> </div>\n            <div class="status_bar_gain" data-bind="style: { width: gain.percent() }"> </div>\n            <div class="status_bar_from_storage" data-bind="style: { left: gain.percent(), width: fromStorage() }"> </div>\n        </div>\n    </div>\n</td>\n<td>\n    <div class="div_rate_ctr_cont" data-bind="css: {economic_limit: limit() == resource}">\n        <div class="div_plusminus_rate_cont">\n            <div class="rate_stat rate_negative_small" id="Div2" data-bind="text: loss.value">-8888</div>\n            <div class="rate_stat rate_positive_small" id="Div1" data-bind="text: gain.value">+8888</div>\n        </div>\n        <div class="div_rate_ctr_overall" data-bind="text: netString">+8888</div>\n    </div>\n</td>\n<td>\n    <div class="div_storage_display">\n        <div class="status_bar_storage_frame">\n            <div class="status_bar_storage" data-bind="style: { height: fractionString() }">\n            </div>\n        </div>\n    </div>\n    <div class="status_stats">\n        <span id="Span1" data-bind="text: currentBfs">8888</span>\n    </div>\n</td>\n';
gross_economy['gross_economy_status_bar'] = function (extendResource, judgement, html) {
    
    var metal = {
            resource: 'metal',
            current: model.currentMetal,
            max: model.maxMetal,
            currentGain: model.metalGain,
            currentLoss: model.metalLoss,
            net: model.metalNet,
            netStringStock: model.metalNetString,
            netStringBfs: ko.computed(function () {
                return (model.metalNet() > 0 ? '+' : '') + Math.round(model.metalNet() / 10);
            }),
            fractionString: ko.computed(function () {
                return '' + (100 * model.metalFraction()).toFixed(0) + '%';
            }),
            min: 20,
            tick: 10,
            judgement: judgement.metal
        };
    var energy = {
            resource: 'energy',
            current: model.currentEnergy,
            max: model.maxEnergy,
            currentGain: model.energyGain,
            currentLoss: model.energyLoss,
            net: model.energyNet,
            netStringStock: model.energyNetString,
            netStringBfs: ko.computed(function () {
                return (model.energyNet() > 0 ? '+' : '') + Math.round(model.energyNet() / 1000);
            }),
            fractionString: ko.computed(function () {
                return '' + (100 * model.energyFraction()).toFixed(0) + '%';
            }),
            min: 2000,
            tick: 1000,
            judgement: judgement.energy
        };
    var settings = decode(localStorage.settings);
    console.log(settings);
    extendResource(metal, settings);
    extendResource(energy, settings);
    var limit = metal.limit = energy.limit = ko.computed(function () {
            if (metal.ratio() < 1) {
                return 'metal';
            } else if (energy.ratio() < 1) {
                return 'energy';
            } else {
                return 'none';
            }
        });
    var effColorCalculated = ko.computed(function () {
            if (energy.ratio() < metal.ratio()) {
                return energy.coloration();
            } else {
                return metal.coloration();
            }
        });
    var effColoration = ko.observable();
    effColorCalculated.subscribe(effColoration);
    var $eff;
    effColoration.subscribe(function (value) {
        if ($eff) {
            $eff.attr('class', 'div_status_bar_cont ' + value);
        }
    });
    var theme = function () {
        switch (settings.gross_economy_theme) {
        default:
        case 'INVERSE':
            return 'div_status_bar_inverse';
        case 'CLASSIC BLACK':
            return 'div_status_bar_black';
        }
    };
    var installTemplate = function ($parent, html, model) {
        $parent.addClass(model.resource);
        $parent.html(html);
        model.$parent = $parent.parents('.div_status_bar_cont');
        ko.applyBindings(model, $parent[0]);
    };
    return {
        ready: function () {
            console.log('Gross Economy ready, modifing status bar');
            installTemplate($('.div_status_bar_left tr'), html, metal);
            installTemplate($('.div_status_bar_right tr'), html, energy);
            $eff = $('.div_status_bar_mid .div_status_bar_cont');
            $('.div_status_bar').addClass(theme);
        },
        metal: metal,
        energy: energy
    };
}(gross_economy['gross_economy_resource'], gross_economy['gross_economy_judgement'], gross_economy['text_gross_economy_status_bar_resourcehtml']);
gross_economy['gross_economy_main'] = function (status_bar) {
    
    $(status_bar.ready);
}(gross_economy['gross_economy_status_bar']);
