var _ = require('thirdparty/lodash');

var default_commanders = ["ProgenitorCommander","AlphaCommander","ThetaCommander"]
var fallback_commander = {
    ObjectName: 'RaptorCenturion',
    UnitSpec: '/pa/units/commanders/raptor_centurion/raptor_centurion.json'
};

function CommanderManager() {
    self = this;

    self.commanders = require('lobby/commander_table').data.slice();
    self.findCommanderByName = function(name) {
        return _.find(self.commanders, function (element) {
            return element.ObjectName === name;
        });
    };

    self.getRandomDefaultCommander = function() {
        var result = self.findCommanderByName(_.sample(default_commanders));
        return result ? result : fallback_commander;
    };
};

exports.CommanderManager = CommanderManager;
