// Technological Merits
// -
// SXX and requisites Unlocked
// Subcommanders: 1
// Direct build of bot fabbers and orbital launcher.
//
// Technological Flaws
// -
// No Navy 
// 1 Slot

define([
    'module',
    'shared/gw_common',
    'shared/gw_factions',
    'cards/gwc_start',
], function (
    module,
    GW,
    GWFactions,
    GWCStart
) {
    var CARD = { id: /[^\/]+$/.exec(module.id).pop() };

    return {
        visible: function (params) { return false; },
        summarize: function (params) {
            return "Adrianna's Butcher of Meanies";
        },
        icon: function (params) {
            return "coui://ui/mods/images/blank.png";
        },
        describe: function (params) { return "Lo did the minions of the goddess of wisdom and love crusade across the universe purging galaxy after galaxy, large and small, weak and strong, of all agents of pain and death, leaving room only for life, joy, and diversity."; },
        getContext: function (galaxy, inventory) {
            return {
                faction: inventory.getTag('global', 'playerFaction') || 0
            };
        },
        deal: function (system, context) {
            var minions = _.shuffle(GWFactions[context.faction].minions.slice(0));
            return {
                params: {
                    minions: minions.slice(0, 1),
                    allowOverflow: true
                },
                chance: 0
            };
        },
        buff: function (inventory, context) {
            if (inventory.lookupCard(CARD) === 0) {
                // Make sure we only do the start buff/dull once
                var buffCount = inventory.getTag("", "buffCount", 0);
                if (!buffCount) {
                    GWCStart.buff(inventory);
                    
                    //increase slot count
                    inventory.maxCards(inventory.maxCards() - 2);

                    //Unit unlocks
                    inventory.addUnits([
                        //'/pa/units/air/air_factory/air_factory.json',
                        //'/pa/units/air/air_scout/air_scout.json',
                        //'/pa/units/air/bomber/bomber.json',
                        //'/pa/units/air/fighter/fighter.json',
						//'/pa/units/orbital/orbital_fighter/orbital_fighter.json'
						//'/pa/units/land/assault_bot/assault_bot.json',
						//'/pa/units/air/fabrication_aircraft/fabrication_aircraft.json',
						//'/pa/units/air/fabrication_aircraft_adv/fabrication_aircraft_adv.json',
						//'/pa/units/land/fabrication_bot/fabrication_bot.json',
						//'/pa/units/land/fabrication_bot_adv/fabrication_bot_adv.json',
						//'/pa/units/land/artillery_long/artillery_long.json',
						//'/pa/units/land/bot_factory/bot_factory.json',
						//'/pa/units/land/bot_bomb/bot_bomb.json',
						'/pa/units/orbital/orbital_fabrication_bot/orbital_fabrication_bot.json',
						'/pa/units/orbital/orbital_laser/orbital_laser.json',
						'/pa/units/orbital/orbital_factory/orbital_factory.json'
						//'/pa/units/air/air_cyclops/air_cyclops.json'
                    ]);
                    inventory.removeUnits([
						"/pa/units/sea/naval_factory/naval_factory.json"
                    ]);
					
                    //code to add sub-commander(s)
                    _.forEach(context.minions, function(minion) {
                        inventory.minions.push(minion);
                    });
                    var minionSpecs = _.pluck(_.filter(_.pluck(context.minions, 'commander')), 'UnitSpec');
                    inventory.addUnits(minionSpecs);

                    //allow commander to build all t1 structures
                    var mods = [];//empty mod array, where mods to units will be added before being applied

                    var comm = [//an array of a group of units to mod the same way
                        '/pa/units/commanders/base_commander/base_commander.json'
                    ];
                    var modUnit = function(unit) {//a function to mod a unit
                        mods.push({//add a mod to the mods array
                            file: unit,//the current unit
                            path: 'buildable_types',//the attribute to alter
                            op: 'replace',//the way to alter, another common way is multiply
                            //value: 'CmdBuild | Structure & Basic | Orbital & Structure & Advanced & Recon | Artillery & Advanced & Structure | Fabber & Construction & Bot' //All basic structures
							value: 'CmdBuild | Fabber & Construction & Bot | orbital & factory & construction & structure & basic' //Com Build Selection Plus Fabber Bots and Orbital Factory
                        });
                        
                        
                    };
                    _.forEach(comm, modUnit);//for every element x of the comm array, execute modUnit(x)

                    inventory.addMods(mods);//apply all unit mods in the mods array

                }
                else {
                    // Don"t clog up a slot.
                    inventory.maxCards(inventory.maxCards() + 1);
                }
                ++buffCount;
                inventory.setTag("", "buffCount", buffCount);
            }
            else {
                // Don"t clog up a slot.
                inventory.maxCards(inventory.maxCards() + 1);
                GW.bank.addStartCard(CARD);
            }
        },
        dull: function (inventory) {
            if (inventory.lookupCard(CARD) === 0) {
                var buffCount = inventory.getTag("", "buffCount", 0);
                if (buffCount) {
                    // Perform dulls here
                    
                    inventory.setTag("", "buffCount", undefined);
                }
            }
        }
    };
});